import Panel from "../views/Panel";
import { G_GetHomeDataByKey, HOME } from "../Scenes/Home";
import Medal from "../Scenes/RoomScene/Medal";

export default class MedalsPanel extends Panel {
    public closeBtn: eui.Button;
    public sGroup: eui.Group;
    public wait1Group: eui.Group;
    public wait2Group: eui.Group;
    public tipsImg: eui.Image;

    private medals: Medal[] = [];

    public get skinKey() {
        return 'MedalsPanel'
    }

    public get groupName() {
        return 'medals';
    }

    constructor(data?) {
        super(data);
    }

    public onShowAnim() {
        // 位置：0.33s(屏幕外)-0.83s(下移1270px至于原位)；
        // 旋转：0.83s(顺时针5度)-1s(逆时针5度)-1.17s(顺时针2度)-1.33s(0度)；
        this.anchorOffsetX = 750 / 2;
        this.x = 750 / 2;
        egret.Tween.get(this)
            .set({y: -870, rotation: 5})
            .wait(330)
            .to({y: 200}, 500, egret.Ease.quartOut)
            .to({rotation: -5}, 170)
            .to({rotation: 2}, 170)
            .to({rotation: 0}, 160);
    }

    protected hideAnim(): egret.Tween {
        let _y = 570 - (1624 - 750 / window.innerWidth * window.innerHeight) / 2;
        egret.Tween.get(this).wait(400).to({alpha: 0}, 100);
        return egret.Tween.get(this).to({x: 510, y: _y, scaleX: 0.1, scaleY: 0.1}, 500, egret.Ease.getPowOut(5));
    }

    protected start() {
        super.start();
        this.initUI();
    }

    private initUI(): void {
        const medals: {} = G_GetHomeDataByKey(HOME.MEDALS);
        let index = 0;
        for(let k in medals) {
            let data = {
                key: k,
                index: index,
                name: medals[k].name,
                active: (medals[k].count > 0),
            };
            let newMedal = new Medal(data);
            this.sGroup.addChild(newMedal);
            this.medals.push(newMedal);
            index++;
        }

        this.tipsImg.visible = (index >= 4);

        this.wait1Group.x = ((this.medals.length) % 2 == 0) ? 55 : 249;
        this.wait1Group.y = 43 + ~~((this.medals.length) / 2) * 230;
        if(this.medals.length % 2 == 0) {
            this.wait2Group.visible = true;
            this.wait2Group.x = ((this.medals.length + 1) % 2 == 0) ? 55 : 249;
            this.wait2Group.y = 43 + ~~((this.medals.length + 1) / 2) * 230;
        }
    }

    public destroy() {
        super.destroy();
        this.medals.forEach(v => v.destroy());
    }
}