import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";

export default class MedalPanel extends Panel {
    public closeBtn: eui.Button;
    public title: eui.Label;
    public light: eui.Image;
    public btn: eui.Image;
    public medal: eui.Image;
    public mask: eui.Image;
    public swap_light: eui.Image;

    constructor(data?) {
        super(data);
    }

    public onShowAnim() {
        // 缩放：0s(0%,0%)-0.23s（120%，120%）-0.33s(100%,100%);
        // 文案和按钮 透明度：0.33s(0%)-0.67s(100%);
        this.anchorOffsetX = 750 / 2;
        this.anchorOffsetY = 900 / 2;
        this.x = 750 / 2;
        this.y = 750 / window.innerWidth * window.innerHeight * 0.15 + 900 / 2;
        egret.Tween.get(this)
            .set({scaleX: 0, scaleY: 0})
            .to({scaleX: 1.2, scaleY: 1.2}, 230)
            .to({scaleX: 1, scaleY: 1}, 100);
    }

    protected onShowAnimCall() {
        egret.Tween.get(this.btn)
            .set({alpha: 0})
            .wait(330)
            .to({alpha: 1}, 340);

        egret.Tween.get(this.title)
            .set({alpha: 0})
            .wait(330)
            .to({alpha: 1}, 340);
    }

    protected getTapEvts(): any[] {
        return super.getTapEvts().concat([
            [this.btn, this.onTap, this],
        ])
    }

    private onTap() {
        SceneCtrl.instance.change(ModuleTypes.ROOM_SCENE, {auto: true});
    }

    protected start() {
        super.start();
        this.initUI();
    }

    private initUI(): void {
        egret.Tween.get(this.light, {loop: true}).to({rotation: 360}, 6000);
        /// TODO 设置 medal 和 mask 的 source
        this.medal.source = `medal_${this.data}_png`;
        this.mask.source = `medal_${this.data}_png`;
        this.swap_light.mask = this.mask;
        // 获得勋章的扫光动效
        // 0.67s-1.67s,间隔时间：1s;
        egret.Tween.get(this.swap_light, {loop: true})
            .set({x: 198})
            .wait(670)
            .to({x: 444}, 1000)
            .wait(330);
    }

    public get skinKey() {
        return 'MedalPanel'
    }

    public get groupName() {
        return 'medal_panel';
    }
}