import Panel from "../views/Panel";
import { G_GetHomeDataByKey, HOME } from "../Scenes/Home";
import { btnDelay, showToast } from "../comm/UtilsConst";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";

export default class ExchangePanel extends Panel {
    public closeBtn: eui.Button;
    public propGroup: eui.Group;
    public sp_1_group: eui.Group;
    public sp_1_label0: eui.Label;
    public add1: eui.Label;
    public sp_2_group: eui.Group;
    public sp_2_label0: eui.Label;
    public add2: eui.Label;
    public sp_3_group: eui.Group;
    public sp_3_label0: eui.Label;
    public add3: eui.Label;
    public sp_4_group: eui.Group;
    public sp_4_label0: eui.Label;
    public btn: eui.Image;
    public title: eui.Label;
    public introduce: eui.Label;
    public stock: eui.Label;

    constructor(data?) {
        super(data);
    }

    onShowAnim() {
        // const canvasH = 750 / window.innerWidth * window.innerHeight;
        egret.Tween.get(this).set({alpha: 0}).to({alpha: 1}, 233, egret.Ease.quadInOut);
    }

    protected getTapEvts(): any[] {
        return super.getTapEvts().concat([
            [this.btn, this.onTap, this],
        ])
    }

    private onTap() {
        btnDelay(this.btn);
        if(this.data.stock <= 0) {
            showToast('商品无库存，耐心等待商品补货后再来吧');
            return;
        }
        if(!this.canGet()) {
            showToast('啊哦，合成所需食材不足，快去赚食材吧');
            return;
        }
        NetManager.ins.prizeExchange((success, res) => {
            if(!success) {
                showToast('啊哦...目前无法兑换哦');
                return;
            }
            PanelCtrl.instance.show(ModuleTypes.EXCHANGED_PANEL, res.data);
        }, this.data.strategyId);

    }

    protected start() {
        super.start();
        this.initUI();

    }

    private initUI(): void {
        this.y = 750 / window.innerWidth * window.innerHeight * 0.2;
        // console.log(this.data);
        this.title.text = this.data.name;
        this.introduce.text = `商品介绍：商品介绍商品介绍商品介绍`;
        this.stock.text = `剩余数量：${this.data.stock}`;
        this.setNeed();
        this.setBtn();
    }

    private setBtn() {
        this.canGet().then(
            (res) => {
                this.btn.source = 'ex_btn_png';
                this.btn.touchEnabled = true;
            },
            (err) => {
                this.btn.source = err;
                this.btn.touchEnabled = false;
            }
        );
    }

    private canGet(): Promise<boolean> {
        return new Promise<boolean>((resolve, reject) => {
            // NetManager.ins.strategyRecords((success, res) => {
            //     if(success && res.data.length >= 1) {   // 已经合成过了，不能合成
            //         reject('ex_btn_done_png');
            //         return;
            //     }
            let showList = [];
            for(let spk in this.data['spMap']) {
                showList.push(spk);
            }
            const products: {} = G_GetHomeDataByKey(HOME.PRODUCT);
            for(let v of showList) {
                if(this.data['spMap'][v] > products[v]) {   // 有一项不足，不能合成
                    reject('ex_btn_dis_png');
                    return;
                }
            }
            resolve(true);  // 以上都没有，可以合成
            // return;
            // }, this.data.strategyId, 5);
        });
    }

    // 显示需要的道具
    private setNeed() {
        let showList = [];
        for(let spk in this.data['spMap']) {
            showList.push(spk);
        }
        // 设置道具下的label
        this.propGroup.width = 38 + 80 * (showList.length - 1);
        const products: {} = G_GetHomeDataByKey(HOME.PRODUCT);
        showList.forEach((v, i) => {
            this[`${v}_group`].visible = true;
            this[`${v}_group`].x = 80 * i;
            this[`${v}_label`].textFlow = <Array<egret.ITextElement>>[
                {
                    text: products[v].toString(),
                    style: {"textColor": (products[v] < this.data['spMap'][v]) ? 0xed3330 : 0xffffff}
                },
                {text: '/' + this.data['spMap'][v], style: {"textColor": 0xffffff}}
            ];
        });

        // 显示+号
        for(let i = 1; i < showList.length; i++) {
            this[`add${i}`].visible = true;
        }
    }

    destroy() {
        super.destroy();
    }

    public get skinKey() {
        return 'ExchangePanel'
    }

    public get groupName() {
        return 'exchange_panel'
    }

}
