import { IExposureData } from './../../common/IExposureData';
// import { GPool } from '../../../../tc/util/GPool';
import { GetInfoData } from './../getInfo/GetInfoData';
import { LotteryData } from './../../common/lottery/LotteryData';
import { Data } from './../../Data';
import { GPool } from '../../../../tc/util/GPool';
/**
 * 获取游戏抽奖结果
 */

export class GameGetSubmitResultData extends Data {
    /**
     * 奖品数据
     */
    public lottery: LotteryData;

    /**
     * 推啊数据埋点
     */
    public exposure: IExposureData;

    /**
     * 再来一次埋点
     */
    public againExposure: IExposureData;

    /**
     * 是否需要继续轮询
     */
    public flag: boolean;

    /**
     * 本局分数
     */
    public score: number;

    public update(result: any): void {
        if(!result) {
            return;
        }
        super.update(result);
        this.flag = result.data.flag;
        if (result.data.option) {
            this.lottery = GPool.takeOut('LotteryData', LotteryData);
            if (!this.lottery) {
                this.lottery = new LotteryData();
            }
            if (!result.data.option.lottery) {
                result.data.option.lottery = {};
            }
            result.data.option.lottery.type = result.data.option.type;
            result.data.option.lottery.stinfodpmgouse = result.data.useDpm;
            result.data.option.lottery.stinfodpmimg = result.data.useDpm;
            result.data.option.lottery.imgurl = result.data.option.image;
            result.data.option.lottery.link = result.data.option.link;
            result.data.option.lottery.name = result.data.option.name;
            result.data.option.lottery.type = result.data.option.type;

            this.lottery.update(result.data.option.lottery);
        } else if (this.lottery) {
            GPool.recover('LotteryData', this.lottery);
            this.lottery = null;
        }
        if (this.lottery) {
            this.exposure = result.data.option.lottery.exposure;
        } else if (this.exposure) {
            this.exposure = null;
        }
        this.againExposure = JSON.parse(result.data.againDpm);
        this.score = result.data.score;
    }
}