/**
 *Created by cuiliqiang on 2018/3/12
 * 闯关游戏提交结果数据
 */
import { Data } from "../../Data";

export class ThroughSubmitData extends Data {
    /**
     * 订单ID
     */
    public orderId: number;

    /**
     * 1:插件式抽奖工具  返回数据中  对一个 plginOrderId   然后调用 collectRule/getOrderStatus?orderId=plginOrderId  查询奖品信息
     * 2:后退 3:前进 4终点  5:活动工具奖品出奖  6:跳转地址
     */
    public type: string;

    /**
     * 插件订单ID 对应type = 1时
     */
    public plginOrderId: number;

    /**
     * 为true 时  需要调用  newActivity/getOrderStatus  查询奖品信息
     */
    public needPrize: boolean;

    /**
     * 
     */
    public point: number;

    /**
     * 当前位置
     */
    public currentLocation: number;

    public update(data: any): void {
        if (!data) {
            return;
        }
        super.update(data);
        this.orderId = data.orderId;
        this.type = data.prizeType;
        this.plginOrderId = data.plginOrderId;
        this.needPrize = data.needPrize;
        this.point = data.point;
        this.currentLocation = data.currentLocation;
    }
}