import LabelType from "./items/LabelType";

const levels = {
    '1': { max: 5, items: [[LabelType.boom, 1], [LabelType.coin, 5+4]], awards: [[5, LabelType.candy]] },
    '2': { max: 10, items: [[LabelType.boom, 2], [LabelType.coin, 10+4]], awards: [[5, LabelType.candy],[10, LabelType.egg]] },
    '3': { max: 15, items: [[LabelType.boom, 3], [LabelType.coin, 15+4]], awards: [[5, LabelType.candy],[10, LabelType.egg],[15, LabelType.gift]] },
    '4': { max: 20, items: [[LabelType.boom, 4], [LabelType.coin, 20+4]], awards: [[5, LabelType.candy],[10, LabelType.egg],[20, LabelType.gift]] },
    '5': { max: 15, items: [[LabelType.boom, 3], [LabelType.coin, 15+4]], awards: [[5, LabelType.candy],[10, LabelType.egg],[15, LabelType.gift]] },
}

export const MAX_LEVELS = 5;

export const toNextLevel = ()=>{
    if(getCurrentScore() < getLevelData().max) return false
    addCurrentLevel();
    clearCurrentScore();
    return true;
}

export const getCurrentItems = () => {
    return getLevelData().items
}

export const getCurrentScore = () => {
    const data = localStorage.getItem('currentScore')
    if (!data)
        return 0
    return parseInt(data)
}

export const addCurrentScore = () => {
    let score = getCurrentScore();
    score++;
    localStorage.setItem('currentScore', score + '')
}

export const clearCurrentScore = () => {
    localStorage.setItem('currentScore', '0')
}

export const getCurrentLevel = () => {
    const data = localStorage.getItem('currentLevel')
    if (!data)
        return 1
    return parseInt(data)
}

export const addCurrentLevel = () => {
    let lv = getCurrentLevel();
    lv++;
    localStorage.setItem('currentLevel', lv + '')
}

export const getCurrentPercent = () => {
    return getCurrentScore() / getLevelData().max;
}

export const onLvBoom = () => {
    clearCurrentScore();
}

export const getLevelData = () => {
    return levels[getCurrentLevel()]
}

export const getLevelAniTag = () => {
    return !!localStorage.getItem(`LevelAniTag${getCurrentLevel()}`)
}

export const setLevelAniTag = () => {
    return localStorage.setItem(`LevelAniTag${getCurrentLevel()}`, '1')
}


