import { StarterBase } from "../StarterBase";

export class SimpleP2APP extends StarterBase {

    private world: p2.World;
    private body: p2.Body;

    public createP2App(): void {
        //创建p2物理世界world
        this.world = new p2.World();
        var world = this.world;
        world.gravity = [10, 10];

        //创建矩形形状shape
        var shape: p2.Box = new p2.Box({ width: 100 / this.factor, height: 50 / this.factor });

        //创建刚体body
        var body: p2.Body = new p2.Body({ mass: 1 });
        body.position = [275 / this.factor, 100 / this.factor];
        body.addShape(shape);
        world.addBody(body);
        this.body = body;


    }

    loop(): void {
        this.world.step(1 / 60);
        console.log(this.body.position);
    }

    protected createGameScene(): void {
        super.createGameScene();
        this.createP2App();
    }

}
window['SimpleP2APP'] = SimpleP2APP;