import { StarterBase } from "../StarterBase";
import p2DebugDraw from "../p2DebugDraw";

export class SimpleP2APPWithDebugDraw extends StarterBase {

    private world: p2.World;
    private debugDraw: p2DebugDraw;

    public createP2App(): void {
        //创建p2物理世界world
        this.world = new p2.World();
        var world = this.world;
        world.gravity = [0, 10];

        //创建矩形形状shape
        var shape: p2.Box = new p2.Box({ width: 100 / this.factor, height: 50 / this.factor });

        //创建刚体body
        var body: p2.Body = new p2.Body({ mass: 1 });
        body.position = [275 / this.factor, 100 / this.factor];
        body.addShape(shape);
        world.addBody(body);

        //添加p2调试试图
        var sprite: egret.Sprite = new egret.Sprite();
        this.addChild(sprite);
        this.debugDraw = new p2DebugDraw(world, sprite);

        //添加游戏帧频事件
        this.addEventListener(egret.Event.ENTER_FRAME, this.loop, this);
    }

    loop(): void {
        this.world.step(1 / 60);
        this.debugDraw.drawDebug();
    }

    protected createGameScene(): void {
        super.createGameScene();
        this.createP2App();
    }

}
window['SimpleP2APPWithDebugDraw'] = SimpleP2APPWithDebugDraw;