import { GamePlayModel } from "../../libs/tw/model/game/GamePlayModel";
import Scene from "../views/Scene";
import BoxListCtrl from "./BoxListCtrl";
import Monkey from "./Monkey";
import Net from "./Net";

const { TouchEvent } = egret;
export default class StartScene extends Scene {
    private _net: Net;
    private _monkey: Monkey;
    private _shape: egret.Shape;
    private _boxList: BoxListCtrl;
    async start(data?) {
        const picData: any = await this.getBg();
        const pic = new egret.Bitmap(picData);
        this.getLayer(LayerTypes.bg).addChild(pic);

        this._boxList = new BoxListCtrl(this.getLayer(LayerTypes.box));
        await this._boxList.createFirstBox();
        this._boxList.createBoxs();

        const monkey = new Monkey();
        this.getLayer(LayerTypes.monkey).addChild(monkey);
        monkey.addEventListener('pointUpdate', this.onPointUpdate, this)
        this._monkey = monkey;

        const net = new Net();
        this.getLayer(LayerTypes.net).addChild(net);


        if (__debug__) {
            this._shape = new egret.Shape();
            this.addChild(this._shape);
        }

        const model = new GamePlayModel();
        model.update();

        // box.touchEnabled = true;
        // box.addEventListener(egret.TouchEvent.TOUCH_BEGIN, () => {
        //     NetManager.ins.getInfo(() => {
        //         model.doStart(() => {
        //             model.submit(() => { }, box.boxData.award)
        //         }, false);
        //     });

        //     PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);

        // }, this);
    }

    onPointUpdate(e: egret.Event) {
        const point = e.data as egret.Point;
        if (__debug__) {
            this._shape.graphics.clear();
            this._shape.graphics.beginFill(0xff0000);
            const size = __monkeyHandSize__;
            const x = point.x + this._monkey.x;
            const y = point.y + this._monkey.y;
            this._shape.graphics.drawRect(x - size / 2, y - size / 2, size, size);
            this._shape.graphics.endFill();
        }
    }
    async getBg() {
        let url =__bgUrl__
        return new Promise((resolve) => {
            RES.getResByUrl(url, (picData) => {
                resolve(picData)
            }, this, RES.ResourceItem.TYPE_IMAGE);
        });
    }

    protected get layerKeys() {
        return [LayerTypes.bg,
        LayerTypes.kids,
        LayerTypes.net,
        LayerTypes.box,
        LayerTypes.monkey,
        LayerTypes.guide]
    }
    protected get skinKey() { return 'Start' }
}

enum LayerTypes {
    bg, kids, box, net, monkey, guide
}