import Box from "./Box";

export default class BoxListCtrl {
    private _parent: egret.Sprite;
    private _boxKeys: string[];

    constructor(parent: egret.Sprite) {
        this._parent = parent;
        this.init();
    }

    init() {
        this._boxKeys = ['woodbox', 'woodbox', 'woodbox'];
    }

    private BOX_CREATE_INTERVAL = 5000;
    private _timer: number;
    private _currentBoxIndex = 0;
    /** 创建其他的boxs */
    createBoxs() {
        setInterval(() => {
            this.createBox();
        }, this.BOX_CREATE_INTERVAL);
    }

    createBox() {
        if (this._currentBoxIndex >= this._boxKeys.length)
            this._currentBoxIndex = this._boxKeys.length - 1;
        const box = new Box(this._boxKeys[this._currentBoxIndex]);
        this._parent.addChild(box);
        box.createBg();
    }

    reset() {
        clearInterval(this._timer);
        this._timer = 0;
        this._currentBoxIndex = 0;
    }

    createFirstBox() {
        return new Promise(async (resolve) => {
            const box = new Box(this._boxKeys[this._currentBoxIndex]);
            this._parent.addChild(box);
            await box.createBg();
            this._currentBoxIndex++;
            resolve();
        })
    }
}