import Panel from "./Panel";
import { DataManager } from "../../tw/manager/DataManager";
import { NetManager } from "../../tw/manager/NetManager";
import RankItem from "./RankItem";

export default class RankPanel extends Panel {
    public ruleBg:eui.Image;
    public closeBtn:eui.Button;
    public scroller:eui.Scroller;
    public group:eui.Group;
    public list:eui.List;
    public title:eui.Image;
    public dog:eui.Image;
    public rankNum:eui.Label;
    public userIdtxt:eui.Label;
    public scoretxt:eui.Label;
    public userItemBg:eui.Image;
    public userRankNum:eui.Label;
    public userId:eui.Label;
    public userScore:eui.Label;
    public num3:eui.Image;
    public num2:eui.Image;
    public num1:eui.Image;
    

    async start() {
        super.start();
        if (!DataManager.ins.realTimeRankData)
            NetManager.ins.realtimerank((success:boolean) => {
                if(success){
                    this.updatePanel();
                }
            },0);
        else
            this.updatePanel();
    }

    updatePanel() {
        if(DataManager.ins.realTimeRankData && DataManager.ins.realTimeRankData.myUserData){
            this.userId.text = `我`;
            this.userRankNum.text = DataManager.ins.realTimeRankData.myUserData && DataManager.ins.realTimeRankData.myUserData.rank ? `${DataManager.ins.realTimeRankData.myUserData.rank}` : '未上榜';
            this.userScore.text = DataManager.ins.realTimeRankData.myUserData && DataManager.ins.realTimeRankData.myUserData.maxScore ? `${DataManager.ins.realTimeRankData.myUserData.maxScore}` : '暂无分数';
            this.list.useVirtualLayout = false;
            this.list.itemRenderer = RankItem;
            const ac = new eui.ArrayCollection(DataManager.ins.realTimeRankData.userList);
            this.list.dataProvider = ac;  
        }else{
            
            this.userId.text = `我`;
            this.userRankNum.text = `未上榜`;
            this.userScore.text = `暂无分数`;
            if(DataManager.ins.realTimeRankData.userList){
                this.list.useVirtualLayout = false;
                this.list.itemRenderer = RankItem;
                const ac = new eui.ArrayCollection(DataManager.ins.realTimeRankData.userList);
                this.list.dataProvider = ac;
            }
        }
    }


     get skinKey() { return 'Rank' }
}