import MovieClip from "../../physics/movieclip/MovieClip";
import LabelType from "../LabelType";

const createCandy2 = (scale) => {
    //气泡纹理种气泡的尺寸默认100（总体还包含气泡周围的阴影效果）
    const texture = RES.getRes('candy2_json') as egret.SpriteSheet;
    const animation = createMovieClip(texture, 0.6 * scale);
    return animation
}

const createMovieClip = (spritesheet: egret.SpriteSheet, scale = 1) => {
    const list = ['1', '2', '3', '4', '5', '6', '7', '8'];
    const movieclip = new MovieClip({
        spritesheet: spritesheet,
        frameInterval: 6,
        frames: list,
        position: [0, 0],
        scale: scale,
        anchor: [.444, .44]
    });
    movieclip.lable = LabelType.Candy2
    return movieclip
}

export default createCandy2