import PlaySceneBase from "../../libs/new_wx/components/PlaySceneBase";
import { GravityParticleSystem } from "../../libs/Particle/GravityParticleSystem";

export default class PlayScene extends PlaySceneBase {
    testBtn: eui.Button;
    initEvents() {

        this.testBtn.once(egret.TouchEvent.TOUCH_TAP, () => {
            this.testBtn.parent.removeChild(this.testBtn);
            this.score = 10;
            this.sendSubmit();
        }, this)
    }
    system:GravityParticleSystem;
    async start(data?) {
        super.start();

        await Promise.all([
            RES.getResAsync("newParticle_png"),
            RES.getResAsync("newParticle_json"),
        ]);



        /*** 本示例关键代码段开始 ***/

        const system = new GravityParticleSystem(
            RES.getRes("newParticle_png"),
            RES.getRes("newParticle_json")
        );
        this.addChild(system);
        system.start();
        system.y = 0;
        system.x = this.stage.stageWidth / 2;
        // system.x = this.stage.stageWidth / 2;
        system.emitterX = 0;
        system.emitterY = 0;

        this.system=system;

        /*** 本示例关键代码段结束 ***/
    }

    destroy(){
        super.destroy();
        this.system.stop(true)
    }
}