import StartScene from "./StartScene";
import createItem from "./items/createItem";
import { award, awardMask } from "./collisionConfig";
import random from "./random";
import LabelType from "./items/LabelType";

export const createNewBubble = (_this: StartScene, type: LabelType) => {
    createBubble(_this, type, Math.random() > 0.5 ? 180 : 750 - 180, 220);
}

const createBubble = (_this: StartScene, type: LabelType, x: number, y: number) => {
    let scale;
    const size = random(70, 100);
    const maxsize = 100;
    scale = size / maxsize;
    const baseItem = createItem(scale, type);
    let angle;
    angle = 0;
    //气泡纹理种气泡的尺寸默认100（总体还包含气泡周围的阴影效果）
    //刚体和贴图尺寸比为1:1.12
    _this._egretRender.circle(x, y, (size - 17) / 2, baseItem,
        {
            frictionAir: 0,
            collisionFilter: { group: award, category: award, mask: awardMask },
            angle: angle,
            label: baseItem.type,
            friction: 0
        });
}

export default (_this: StartScene) => {
    let count = 0;
    const coinsFall = setInterval(() => {
        if (count < 14) {
            // const types = [ LabelType.candy, LabelType.coin, LabelType.gift,LabelType.egg]
            const types = [LabelType.boom, LabelType.candy, LabelType.coin, LabelType.gift, LabelType.egg]
            const i = Math.floor(Math.random() * types.length);
            const type = types[i];
            createBubble(_this, type, 375 + Math.random() * 200 - 100, 400 + 200 + 100)
            count++;
        } else {
            //结束
        }
    }, 100);
}