import { ExmlPlugin } from "built-in";
import { ExmlPlugin2 } from "./ExmlPlugin2";

/**
 * 示例自定义插件，您可以查阅 http://developer.egret.com/cn/github/egret-docs/Engine2D/projectConfig/cmdExtensionPlugin/index.html
 * 了解如何开发一个自定义插件
 */
export class MyExmlPlugin extends ExmlPlugin2 implements plugins.Command {
    async onFile(file: plugins.File) {
        const excludes = [
            'openstate.png',
            'coin.png',
            'gift.png',
            'gift2.png',
            'goldenbox.png',
            'silverbox.png',
            'woodbox.png',
            'monkey.png',
            'net.png'
        ];
        if (excludes.indexOf(file.basename) != -1) {
            return file;
        }

        return super['onFile'](file);
    }
}