import { Data } from "../Data";

/**
 * 宠物状态刷新
 */
export class PetStatusData extends Data {
    /**
     * 当前状态（1:正常 2:外出 3:吃饭 4:学习 5:喝水 6:睡觉）
     */
    public status: number;

    /**
     * 状态过期倒计时（单位：分钟，目前只针对吃饭状态有此值）
     */
    public leftMinutes: string;

    public update(result: any): void {
        if (!result || !result.data) {
            return;
        }
        super.update(result);
        result = result.data;
        this.status = result.status;
        this.leftMinutes = result.leftMinutes;
    }
}