import { check_webp_feature } from "../tc/util/GFun";
import { DataManager } from "../tw/manager/DataManager";
import { NetManager } from "../tw/manager/NetManager";
import AssetAdapter from "./adapter/AssetAdapter";
import ThemeAdapter from "./adapter/ThemeAdapter";
import Alert from "./components/Alert";
import HTMLRulePanel from "./components/HTMLRulePanel";
import Loading from "./components/Loading";
import OptionsPanel from "./components/OptionsPanel";
import PlaySceneBase from "./components/PlaySceneBase";
import PrizePanel from "./components/PrizePanel";
import RulePanel from "./components/RulePanel";
import StartSceneBase from "./components/StartSceneBase";
import PanelCtrl from "./ctrls/panelCtrl";
import SceneCtrl from "./ctrls/sceneCtrl";
import showAlertPanel from "./ctrls/showAlertPanel";
import { ModuleTypes } from "./types/sceneTypes";
import layers from "./views/layers";
import RankPanel from "./components/RankPanel";
import getResPath from "../new_tc/getResPath";

export default class MainBase extends eui.UILayer {
    constructor() {
        super();
        check_webp_feature();
    }

    protected registerModules() {
        const panels = [
            [ModuleTypes.ALERT_PANEL, { cls: Alert }],
            [ModuleTypes.RULE_PANEL, { cls: RulePanel }],
            [ModuleTypes.HTML_RULE_PANEL, { cls: HTMLRulePanel }],
            [ModuleTypes.OPTIONS_PANEL, { cls: OptionsPanel }],
            [ModuleTypes.PRIZE_PANEL, { cls: PrizePanel }],
            [ModuleTypes.RANK_PANEL, { cls: RankPanel }],
        ];

        const scenes = [
            [ModuleTypes.START_SCENE, this.startSceneConfig],
            [ModuleTypes.PALY_SCENE, this.playSceneConfig]
        ];

        panels.forEach(item => PanelCtrl.instance.registerPanel(item[0], item[1]));
        scenes.forEach(item => SceneCtrl.instance.registerScene(item[0], item[1]));

        NetManager.ins.onNotSuccess = (msg) => {
            showAlertPanel(msg)
        }
    }

    protected get startSceneConfig() {
        return { cls: StartSceneBase }
    }
    protected get playSceneConfig() {
        return { cls: PlaySceneBase }
    }

    protected getData() {
        NetManager.ins.getInfo();
    }

    protected createChildren(): void {
        super.createChildren();
        egret.lifecycle.addLifecycleListener((context) => {
            // custom lifecycle plugin
        })

        egret.lifecycle.onPause = () => {
            // egret.ticker.pause();
        }

        egret.lifecycle.onResume = () => {
            // egret.ticker.resume();
        }

        //inject the custom material parser
        //注入自定义的素材解析器
        const assetAdapter = new AssetAdapter();
        egret.registerImplementation("eui.IAssetAdapter", assetAdapter);
        egret.registerImplementation("eui.IThemeAdapter", new ThemeAdapter());

        egret.ImageLoader.crossOrigin = "anonymous";

        DataManager.ins.gameCfgData = window['CFG'];
        DataManager.ins.gameCfgData.gameInfo.gameId = window["gameId"];

        layers.init(this);
        Loading.init(layers.topLayer);
        PanelCtrl.instance.init(layers.popupLayer);
        SceneCtrl.instance.init(layers.sceneLayer);

        this.stage.scaleMode = egret.StageScaleMode.FIXED_WIDTH;

        this.registerModules();

        this.loadFirstScreen();
        this.loadAtlas();
        this.getData();
        RES.setMaxLoadingThread(10);
        this.runGame().catch(e => {
            console.log(e);
        })
    }

    loadAtlas() {
        if (!window['development']) {
            const urlJSON = getResPath() + "resource/TextureMerger/loading.json";
            const request = new egret.HttpRequest();
            request.open(urlJSON, egret.HttpMethod.GET);
            request.send();

            const url = getResPath() + "resource/TextureMerger/loading.png";
            const imageLoader = new egret.ImageLoader();
            imageLoader.load(url);
        }
    }

    _firstBgLoaded = false;
    loadFirstScreen() {
        this.loadFirstBG((bitmap: egret.Bitmap) => {
            const t = Date.now() - window['__startTime__'];
            console.log(`首屏显示时间：${t}ms`);
            layers.addFirstBackground(bitmap);
            this._firstBgLoaded = true;
            this.check();
        });
    }

    loadFirstBG(callback) {
        const onImageLoaded = (e: egret.Event) => {
            const imageLoader: egret.ImageLoader = e.currentTarget;
            const bitmapData: egret.BitmapData = imageLoader.data;
            const texture = new egret.Texture();
            texture._setBitmapData(bitmapData);
            const bitmap = new egret.Bitmap(texture);
            callback(bitmap);
        }
        const imageLoader = new egret.ImageLoader();
        imageLoader.once(egret.Event.COMPLETE, onImageLoaded, this);
        const url = getResPath() + "resource/assets/startScene/bg.jpg"
        imageLoader.load(url);
    }

    private async runGame() {
        await this.loadResource()
        this.createGameScene();
    }

    private async loadResource() {
        try {
            await RES.loadConfig("default.res.json", getResPath() + "resource/");
            await this.loadTheme();
        }
        catch (e) {
            console.error(e);
        }
    }

    private loadTheme() {
        return new Promise((resolve, reject) => {
            // load skin theme configuration file, you can manually modify the file. And replace the default skin.
            //加载皮肤主题配置文件,可以手动修改这个文件。替换默认皮肤。
            const theme = new eui.Theme("resource/default.thm.json", this.stage);
            theme.addEventListener(eui.UIEvent.COMPLETE, () => {
                resolve();
            }, this);

        })
    }

    /**
     * 创建场景界面
     * Create scene interface
     */
    _startSceneReady = false;
    protected createGameScene() {
        SceneCtrl.instance.change(ModuleTypes.START_SCENE, null, () => {
            this._startSceneReady = true;
            this.check();
        });
    }

    check() {
        if (this._startSceneReady && this._firstBgLoaded) {
            layers.removeFirstBackground();
            const t = Date.now() - window['__startTime__'];
            console.log(`start scene显示时间：${t}ms`);
            //开始场景图集和开始场景背景全部加载完成并显示
        }

    }
}