import { addImage } from "./utils";

export default class Ball extends p2.Body {
    _skin: egret.DisplayObject;
    constructor(options?: any) {
        super(options);
        this.init();
    }

    private init() {
        this._skin = addImage('ball_png');
        this._skin.anchorOffsetX = this._skin.width / 2;
        this._skin.anchorOffsetY = this._skin.height / 2;

        const radius = this._skin.width / 2;
        const shape = new p2.Circle({ radius: radius });
        this.addShape(shape);

        this.mass = 1;
    }

    updateSkin() {
        this._skin.x = this.position[0];
        this._skin.y = this.position[1];
        this._skin.rotation = this.angle * 180 / Math.PI;
    }

    get skin() { return this._skin }
}