import LabelType from "./LabelType";
import StartScene from "./StartScene";
const groups = [LabelType.Candy2, LabelType.Donut, LabelType.Egg, LabelType.Gift2, LabelType.IceCream]
let currentLv;
currentLv = groups[0];
let data: any = {};
let that: StartScene;
const MAX = 3;

export const initLevel = ($that: StartScene) => {
    that = $that;
    updateLevelView();
    initProgressBar();
    updateProgressBar(currentLv);
}

export const isLevelPass = () => {
    return getProgress(currentLv) == MAX
}

export const addItem = (type) => {
    if (currentLv != type) return;
    if (data[type] == undefined)
        data[type] = 0;
    data[type]++;
    if (data[type] > MAX)
        data[type] = MAX;
    updateLevelView();
}

export const clear = () => {

}

export const nextLevel = () => {
    const i = groups.indexOf(currentLv);
    currentLv = groups[i + 1];
    updateLevelView();
}

export const updateLevelView = () => {
    hideAllGroup();
    that[currentLv].visible = true;
    setProgress(currentLv, getProgress(currentLv));
}

const getProgress = (type) => {
    if (data[type] == undefined)
        return 0
    return data[type];
}

const setProgress = (type, progress) => {
    hideAllItem(type);
    if (progress == 0) {
        that[`${type}_0_1`].visible = true;//0是背景
        that[`${type}_0_2`].visible = true;
        that[`${type}_0_3`].visible = true;
        that[`${type}_1_1`].visible = false;
        that[`${type}_1_2`].visible = false;
        that[`${type}_1_3`].visible = false;
    }
    if (progress == 1) {
        that[`${type}_0_1`].visible = false;//0是背景
        that[`${type}_0_2`].visible = true;
        that[`${type}_0_3`].visible = true;
        that[`${type}_1_1`].visible = true;
        that[`${type}_1_2`].visible = false;
        that[`${type}_1_3`].visible = false;
    }
    if (progress == 2) {
        that[`${type}_0_1`].visible = false;//0是背景
        that[`${type}_0_2`].visible = false;
        that[`${type}_0_3`].visible = true;
        that[`${type}_1_1`].visible = true;
        that[`${type}_1_2`].visible = true;
        that[`${type}_1_3`].visible = false;
    }
    if (progress == 3) {
        that[`${type}_0_1`].visible = false;//0是背景
        that[`${type}_0_2`].visible = false;
        that[`${type}_0_3`].visible = false;
        that[`${type}_1_1`].visible = true;
        that[`${type}_1_2`].visible = true;
        that[`${type}_1_3`].visible = true;
    }
}

const hideAllGroup = () => {
    groups.forEach(group => {
        that[group].visible = false;
    })
}

const hideAllItem = (type) => {
    const names = getItemNames(type);
    names.forEach(name => that[name].visible = false);
}

const getItemNames = (type) => {
    const list = [];
    for (let i = 1; i <= 3; i++) {
        list.push(`_0_${i}`);
    }
    for (let i = 1; i <= 3; i++) {
        list.push(`_1_${i}`);
    }
    return list.map(item => `${type}${item}`)
}

const initProgressBar = () => {
    const progressfg = that['progressfg'];
    const rect = new egret.Shape();
    rect.graphics.beginFill(0);
    rect.graphics.drawRect(0, 0, 558, 60);
    rect.graphics.endFill();
    progressfg.mask = rect;
    progressfg['rect']=rect;
}

const updateProgressBar = (type) => {
    const progressfg = that['progressfg'];
    const rect:egret.Shape= progressfg['rect'];
    rect.graphics.clear();
    rect.graphics.beginFill(0);
    rect.graphics.drawRect(0, 0, 1, 60);
    rect.graphics.endFill();
    // progressfg
}