import { GameModel } from '../common/GameModel';
import { DataManager } from './../../manager/DataManager';
import { TwLang } from '../../util/TwLang';
import { GFun } from '../../../tc/util/GFun';
export class GameLoseModel extends GameModel {
    /**
     * 剩余次数文案
     */
    public get costTxt(): string {
        return DataManager.ins.getInfoData.status.text;
    }

    /**
    * 排名文案
    * @param str
    */
    public getRankTxt(str: string = TwLang.lang_018): string {
        return GFun.replace(str, [DataManager.ins.getInfoData.rank]);
    }

    /**
     * 排名百分比
     * @param str
     */
    public getPercentageTxt(str: string = TwLang.lang_017): string {
        return GFun.replace(str, [DataManager.ins.getInfoData.percentage]);
    }

    /**
     * 当前得分文案
     * @param str 
     */
    public getCurrScoreTxt(str: string = TwLang.lang_009): string {
        return GFun.replace(str, [DataManager.ins.gameGetSubmitResultData.score]);
    }

    /**
     * 获取最高积分
     * @param maxStr 
     * @param totalStr 
     */
    public getMaxScoreTxt(maxStr: string = TwLang.lang_010, totalStr: string = TwLang.lang_011): string {
        let str: string;
        if (DataManager.ins.gameCfgData.gameInfo.openTotalScoreSwitch) {
            str = GFun.replace(totalStr, [DataManager.ins.getInfoData.totalScore]);
        } else {
            str = GFun.replace(maxStr, [DataManager.ins.getInfoData.maxScore]);
        }
        return str;
    }
}