import SheetAnimation from "../components/SheetAnimation";
import IBoxItem from "./IBoxItem";

export default class Box extends egret.Sprite {
    private _pic: SheetAnimation;
    private _type: string;
    private _moveSpeed = 3;
    constructor(type) {
        super();
        this._type = type;
        this._pic = new SheetAnimation();
        this.addChild(this._pic);
    }

    start() {
        this.x = 750 / 2 + 20;
        this.y = 400;
        // this.scaleX=this.scaleY=0.5;
        this.move();
    }

    move() {
        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    }

    private _onDisappear: boolean;
    disappear() {
        this._onDisappear = true;
        this._pic.destroy();
        egret.Tween.get(this).to({ alpha: 0 }, 500).call(this.destroy, this);
    }

    destroy() {
        this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
        this.parent.removeChild(this);
    }

    stopMove() {

    }

    onEnterFrame() {
        this.y += this._moveSpeed;
        if (this.y > 1106 && !this._onDisappear) {
            this.disappear();
        }
    }

    async createBg() {
        let url = this.boxData.skin;
        return new Promise((resolve) => {
            RES.getResByUrl(url, (sheet: egret.SpriteSheet) => {
                this.start();
                this._pic.sheet = sheet;
                this._pic.fps = 10;
                this._pic.play();
                this.alpha = 0;
                egret.Tween.get(this).to({ alpha: 1 }, 500);
                this.anchorOffsetX = this.boxData.offset[0];
                this.anchorOffsetY = this.boxData.offset[1];
                resolve(this);
            }, this, RES.ResourceItem.TYPE_SHEET);
        });
    }

    get type() { return this._type }
    get boxData(): IBoxItem { return window['boxmap'][this._type]; }
    static getBoxList() {
        const list = [];
        for (const key in window['boxmap']) {
            if (window['boxmap'].hasOwnProperty(key)) {
                const element = window['boxmap'][key];
                list.push(key);
            }
        }
        return list;
    }
}