import getAngle from "../physics/utils/getAngle";
import { award, awardMask } from "./collisionConfig";
import createItem from "./items/createItem";
import LabelType from "./LabelType";
import StartScene from "./StartScene";
import { isAllLevelPass } from "./level";

const startY = 984 - 100 - 60;
const startX = 100;
const restitution = 0.7;
// const types = [LabelType.Candy2,LabelType.Donut,LabelType.Egg];
const types = [LabelType.Boom, LabelType.IceCream, LabelType.Donut, LabelType.Candy2, LabelType.Gift2, LabelType.Egg];
let frameInterval = 10;
let pastFrame = 0;
let _this;

const ontick = () => {
    if (pastFrame < frameInterval) {
        pastFrame++;
        return
    };
    let tags = 0;
    let dir;
    if (localStorage.getItem('guilde1') == '1') tags = 1;
    if (localStorage.getItem('guilde2') == '1') tags = 2;
    if (pastFrame >= frameInterval) pastFrame = 0;
    let i = Math.floor(Math.random() * types.length);
    if (tags == 0) {
        i = 1; dir = 'left'; frameInterval = 180;
    }
    else if (tags == 1) {
        i = 0; dir = 'right'
    }
    else if (tags == 2) {
        frameInterval = 60;
        dir = null;
    }
    // if(i==0)i = Math.floor(Math.random() * types.length);
    // i=4;
    const type = types[i];
    let body;
    if (type == LabelType.Candy2) {
        const forceScale = 15;
        const leftStart = { x: startX, y: startY, forceX: 0.01 * forceScale };
        const rightStart = { x: 750 - startX, y: startY, forceX: -0.01 * forceScale };
        const isleft = Math.random() > 0.5;
        console.log('isleft', isleft)
        const start = isleft ? leftStart : rightStart;
        const scale = 2;
        const baseItem = createItem(scale, type);
        body = _this._egretRender.rectangle(start.x, start.y, 49 * scale, 18 * scale, baseItem,
            {
                isStatic: false,
                force: { x: start.forceX, y: 0 },
                friction: 0,
                restitution: restitution,
                label: type,
                angle: getAngle(10),
                collisionFilter: { group: award, category: award, mask: awardMask }
            }
        );
    } else {
        const forceScale = 10;
        const leftStart = { x: startX, y: startY, forceX: 0.01 * forceScale };
        const rightStart = { x: 750 - startX, y: startY, forceX: -0.01 * forceScale };
        let start = Math.random() > 0.5 ? leftStart : rightStart;
        if (dir == 'left') {
            start = leftStart;
        } else if (dir == 'right') {
            start = rightStart;
        }
        const size = 49 * 1.15;
        const maxsize = 49;
        const baseItem = createItem(size / maxsize, type);
        body = _this._egretRender.circle(start.x, start.y, size / 2, baseItem,
            {
                label: type,
                isStatic: false,
                force: { x: start.forceX, y: 0 },
                friction: 0,
                restitution: restitution,
                collisionFilter: { group: award, category: award, mask: awardMask }
            }
        );
    }
    return false;
}


export default ($this: StartScene) => {
    _this = $this;
    if (isAllLevelPass()) return;
    egret.startTick(ontick, this)
}

export const stopCreateItems = () => {
    egret.stopTick(ontick, this);
}