import StartScene from "./StartScene";
import { basket } from "./collisionConfig";
import LabelType from "./LabelType";

export default (that: StartScene) => {
    Matter.Events.on(that._engine, 'collisionEnd', (event) => {
        const pairs = event.pairs;
        for (const pair of pairs) {
            const { bodyA, bodyB } = pair;
            if ((bodyA.label != LabelType.Boom && bodyB.collisionFilter.group == basket)
                || bodyB.label != LabelType.Boom && bodyA.collisionFilter.group == basket) {
                that.onCollision(bodyA.collisionFilter.group == basket ? bodyB : bodyA);
                break;
            }

            if ((bodyA.label == LabelType.Boom && bodyB.collisionFilter.group == basket)
                || bodyB.label == LabelType.Boom && bodyA.collisionFilter.group == basket) {
                that.onCollisionBoom(bodyA.label == LabelType.Boom ? bodyA : bodyB);
                break;
            }
        }
    });
}