import showPlugLog from "../../libs/new_tw/ctrls/showPlugLog";
import Panel from "../../libs/new_wx/components/Panel";
import { LotteryType } from "../../libs/tw/enum/LotteryType";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { globalData } from "../hdTool";

export default class BoomPrizePanel extends Panel {
    start(data) {
        const lottery = globalData.lottery//DataManager.ins.getPlugOrderStatusData.lottery;
        this.data = lottery;
        this.data.imgurl = this.data.img = this.data.imgUrl;

        this.img.width = this.picBigWidth;
        this.img.height = this.picBigWidth / this.bigPicRatio;

        // showPlugLog(lottery);
        //@ts-ignore
        var type = lottery.type;
        if (type == LotteryType.COUPON || type == LotteryType.LUCKY) {
            this.img.width = this.picBigWidth;
            this.img.height = this.picBigWidth / this.bigPicRatio;
        } else {
            this.img.width = this.picBigWidth / this.bigPicRatio;
            this.img.height = this.picBigWidth / this.bigPicRatio;
        }
    }

    initEvents() {
        super.initEvents();
        this.useBtn.once(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.img.once(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
    }

    onUse() {
        const lottery: any = globalData.lottery;
        if (lottery.type == LotteryType.COUPON || lottery.type == LotteryType.LUCKY) {
            window["downloadAppConfig"] =
            {
                openUrl: lottery.openUrl,
                iosDownloadUrl: lottery.iosDownloadUrl,
                androidDownloadUrl: lottery.androidDownloadUrl,
                confirm: lottery.confirm ? lottery.confirm : false
            };
            window["downloadApp"]();
            // if (lottery.type == "lucky") {
            //     NetManager.ins.spmclick(DataManager.ins.gameGetSubmitResultData.exposure);
            // }
        }
        else {
            window.location.href = lottery.link;
        }
    }

    get picBigWidth() { return 510 };
    get bigPicRatio() { return 640 / 300 }

    get skinKey() { return 'BoomPrize' }

    img: eui.Image;
    useBtn: eui.Button;

    protected get closeBtns(): eui.Button[] {
        return [this['closeBtn']]
    }
}