import { IModuleData } from "../interface/IModuleData";
/**
 * 场景管理器
 */
export abstract class ABSceneManager {
    constructor() {
    }

    /**
     * 切换场景
     * @param {ModuleData} module 模块数据
     * @param {any} data 携带数据
     */
    public abstract change(moduleData: IModuleData, data?: any): void

    /**
     * 调用场景方法
     * @param {ModuleName} moduleName
     * @param {string} funcName
     * @param args 携带参数
     */
    public abstract callFunc(moduleName: string, funcName: string, ...args): void

    /**
     * 当前场景名字
     */
    public abstract get currSceneName(): string
}