"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Loading_1 = require("../loading/Loading");
var PanelCtrl = (function () {
    function PanelCtrl() {
        this.canvasH = 750 / window.innerWidth * window.innerHeight;
        this.canvasW = 750 / window.innerWidth * window.innerWidth;
    }
    Object.defineProperty(PanelCtrl, "instance", {
        get: function () {
            return PanelCtrl._instance || (PanelCtrl._instance = new PanelCtrl());
        },
        enumerable: true,
        configurable: true
    });
    PanelCtrl.prototype.init = function (parent) {
        this._parent = parent;
    };
    PanelCtrl.prototype.registerPanelClass = function (name, definition) {
        this._panelClassMap = this._panelClassMap || {};
        this._panelClassMap[name] = definition;
    };
    PanelCtrl.prototype.registerPanels = function (panels) {
        var _this = this;
        panels.forEach(function (v) { return _this.registerPanelClass(v[0], v[1]); });
    };
    /**
     * 防止连点
     * @param targe 可交互对象
     * @param dtime 延时默认500ms
     */
    PanelCtrl.prototype.btnDelay = function (targe, dtime) {
        if (dtime === void 0) { dtime = 500; }
        targe.touchEnabled = false;
        setTimeout(function () {
            targe.touchEnabled = true;
        }, dtime);
    };
    /**
     * 显示
     * @param type 类型
     * @param data 数据
     */
    PanelCtrl.prototype.show = function (type, data) {
        if (this._current) {
            this._current.destroy(); /// TODO 不知道谁干的，没写这句导致事件清除不完善！自定义事件起冲突
            this.remove(this._current, true);
            this._current = null;
        }
        this._parent.visible = true;
        this.addMask();
        var cls = this._panelClassMap[type];
        var panel = new cls(data);
        Loading_1.default.instace.show();
        this._current = panel;
        this.add(panel);
        // panel.visible = false;   /// TODO 不知道谁干的，有什么用？
        panel.onShowAnim(); // 自定义显示动画
        return panel;
    };
    /**
     * 加入黑色蒙层
     */
    PanelCtrl.prototype.addMask = function () {
        if (!this._mask) {
            this._mask = new egret.Sprite();
            this._mask.touchEnabled = true;
            this._mask.graphics.beginFill(0, .4);
            this._mask.graphics.drawRect(0, 0, this.canvasW, this.canvasH);
            this._mask.graphics.endFill();
        }
        this._mask.alpha = 1;
        this._parent.addChild(this._mask);
    };
    PanelCtrl.prototype.add = function (panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
    };
    /**
     * 移除蒙层
     */
    PanelCtrl.prototype.removeMask = function (rightNow) {
        if (rightNow === void 0) { rightNow = false; }
        // if (this._mask) {
        //     if (rightNow) {
        //         this._parent.removeChild(this._mask);
        //     } else
        //         egret.Tween.get(this._mask).to({ alpha: 0 }, 300, egret.Ease.quartIn).call(
        //             () => this._parent.removeChild(this._mask), this);
        // }
        this._parent.visible = false;
    };
    PanelCtrl.prototype.remove = function (panel, rightNow) {
        var _this = this;
        if (rightNow === void 0) { rightNow = false; }
        if (rightNow) {
            this._parent.removeChild(panel);
            this.removeMask(rightNow);
            return;
        }
        panel.onHide().call(function () {
            _this._parent.removeChild(panel);
            _this.removeMask();
        });
        // /// TODO 改造自定义移除动画
        // const tw = egret.Tween.get(panel);
        // tw.to({ y: this.canvasH }, 300, egret.Ease.quartIn)
        //     .call(() => {
        //         this._parent.removeChild(panel);
        //         this.removeMask();
        //     }, this);
    };
    PanelCtrl.prototype.removeCurrent = function () {
        this._current && this._parent.removeChild(this._current) && (this._current = null);
        this._mask && this.removeMask(true);
    };
    /**
     * 隐藏Panel
     * @param e
     */
    PanelCtrl.prototype.onPanelHide = function (e) {
        var panel = e.target;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.remove(panel);
        this._current = null;
    };
    return PanelCtrl;
}());
exports.default = PanelCtrl;
__reflect(PanelCtrl.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/ctrls/panelCtrl\".PanelCtrl");
//# sourceMappingURL=panelCtrl.js.map