"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Scene_1 = require("../../views/Scene");
var sceneCtrl_1 = require("../../ctrls/sceneCtrl");
var sceneTypes_1 = require("../../types/sceneTypes");
var NetManager_1 = require("../../../libs/tw/manager/NetManager");
var panelCtrl_1 = require("../../ctrls/panelCtrl");
var GDispatcher_1 = require("../../../libs/tc/util/GDispatcher");
var utils_1 = require("../../utils");
var UtilsConst_1 = require("../../comm/UtilsConst");
var Home_1 = require("../Home");
var getlogItem_1 = require("../../comm/getlogItem");
exports.shopSpData = {
    sp_prop_1: {
        spId: 'sp_prop_1',
        name: 'speed',
        title: '加速卡',
        price: 0,
        stock: 0,
        introduce: '加速'
    },
    sp_food_1: {
        spId: 'sp_food_1',
        name: 'food',
        title: '饲料',
        price: 0,
        stock: 0,
        introduce: '喂食'
    },
    sp_food_2: {
        spId: 'sp_food_2',
        name: 'water',
        title: '水',
        price: 0,
        stock: 0,
        introduce: '浇水'
    },
};
var ruNum = 20; // 发奖规则的个数
var ShopScene = (function (_super) {
    __extends(ShopScene, _super);
    function ShopScene(data) {
        var _this = _super.call(this, data) || this;
        _this.prizeData = {};
        _this.canShow = true;
        return _this;
    }
    ShopScene.prototype.start = function () {
        _super.prototype.start.call(this);
        this.initUI();
    };
    ShopScene.prototype.reset = function () {
        this.getPropInfo(); // 获得道具详情
        this.setGoods();
    };
    ShopScene.prototype.initUI = function () {
        this.group.height = 750 / window.innerWidth * window.innerHeight;
        NetManager_1.NetManager.ins.showLog(getlogItem_1.getlogItem(19));
        NetManager_1.NetManager.ins.showLog(getlogItem_1.getlogItem(20));
        NetManager_1.NetManager.ins.showLog(getlogItem_1.getlogItem(22));
        NetManager_1.NetManager.ins.showLog(getlogItem_1.getlogItem(23));
        NetManager_1.NetManager.ins.showLog(getlogItem_1.getlogItem(24));
        this.reset();
    };
    ShopScene.prototype.getTapEvts = function () {
        return _super.prototype.getTapEvts.call(this).concat([
            [this.backBtn, this.onTouchTap, this],
            [this.goodsBtn, this.onTouchTap, this],
            [this.propBtn, this.onTouchTap, this],
        ]);
    };
    ShopScene.prototype.buyProp = function (e) {
        UtilsConst_1.btnDelay(e.target);
        var data = null;
        switch (e.target) {
            case this.speedBtn:// 买加速卡
                NetManager_1.NetManager.ins.clickLog(getlogItem_1.getlogItem(22));
                data = exports.shopSpData['sp_prop_1'];
                break;
            case this.waterBtn:// 买水
                NetManager_1.NetManager.ins.clickLog(getlogItem_1.getlogItem(23));
                data = exports.shopSpData['sp_food_2'];
                break;
            case this.foodBtn:// 买饲料
                NetManager_1.NetManager.ins.clickLog(getlogItem_1.getlogItem(24));
                data = exports.shopSpData['sp_food_1'];
                break;
            default:
                break;
        }
        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.SHOP_BUY_PANEL, data);
    };
    ShopScene.prototype.onTouchTap = function (e) {
        switch (e.target) {
            case this.backBtn:
                UtilsConst_1.btnDelay(this.backBtn);
                egret.Tween.get(this.backBtn)
                    .to({ scaleX: 1.2, scaleY: 0.8 }, 80)
                    .to({ scaleX: 1, scaleY: 1 }, 80)
                    .call(function () {
                    sceneCtrl_1.default.instance.change(sceneTypes_1.ModuleTypes.MAIN_SCENE);
                });
                break;
            case this.goodsBtn:
                NetManager_1.NetManager.ins.clickLog(getlogItem_1.getlogItem(19));
                this.goodsBtn.source = '商品w_png';
                this.propBtn.source = '道具b_png';
                this.goodsGroup.visible = true;
                this.propGroup.visible = false;
                this.setGoods();
                break;
            case this.propBtn:
                NetManager_1.NetManager.ins.clickLog(getlogItem_1.getlogItem(20));
                this.goodsBtn.source = '商品b_png';
                this.propBtn.source = '道具w_png';
                this.goodsGroup.visible = false;
                this.propGroup.visible = true;
                this.getPropInfo();
                break;
            default:
                break;
        }
    };
    /**
     * 设置商品列表
     */
    ShopScene.prototype.setGoods = function () {
        var _this = this;
        Home_1.G_UpdateHomeData().then(function () {
            _this.getGoodsInfo().then(function () {
                var _d = [];
                for (var k in _this.prizeData) {
                    _d.push(_this.prizeData[k]);
                }
                _this.none.visible = (_d.length <= 0);
                _this.have.visible = !(_d.length <= 0);
                _this.list.useVirtualLayout = false;
                _this.list.itemRenderer = ShopItem;
                _this.list.dataProvider = new eui.ArrayCollection(_d);
            }).catch(function () {
                _this.none.visible = true;
                _this.have.visible = false;
            });
        });
    };
    /**
     * 查询商品并设置好信息
     * @returns {Promise}
     */
    ShopScene.prototype.getGoodsInfo = function () {
        var _this = this;
        // 聚合查询
        var querys = {};
        for (var i = 1; i <= ruNum; i++) {
            querys["ru_item_" + i] = {
                path: "/ru_item_" + i + ".query",
                params: {},
            };
        }
        return new Promise(function (resolve, reject) {
            ///////////////////////// 查询商店列表 /////////////////////////
            NetManager_1.NetManager.ins.mergeQuery(function (success, res) {
                if (!success) {
                    reject();
                    return;
                }
                var data = res.data;
                var prizeIds = '';
                for (var k in data) {
                    var _d = JSON.parse(data[k]);
                    if (!_d.success) {
                        continue;
                    }
                    for (var i = 0; i <= _d.data.length; i++) {
                        if (_d.data[i].prizeId == 'thanks') {
                            _d.data.splice(i, 1);
                        }
                    }
                    if (_d.data.length <= 0) {
                        continue;
                    }
                    _this.prizeData[_d.data[0]['prizeId']] = UtilsConst_1.deepClone(_d.data[0]); // 保存商品信息
                    _this.prizeData[_d.data[0]['prizeId']]['strategyId'] = k; // 保存规则Id
                    prizeIds += k + ":" + _d.data[0]['prizeId'] + ",";
                    _this.prizeData[_d.data[0]['prizeId']]['canGet'] = true;
                    (_this.canShow) ? NetManager_1.NetManager.ins.showLog(getlogItem_1.getlogDpm(21, +k.slice(8))) : 0;
                }
                _this.canShow = false;
                prizeIds = prizeIds.slice(0, prizeIds.length - 1);
                ///////////////////////// 查询库存和需要的道具信息 /////////////////////////
                NetManager_1.NetManager.ins.prizeInfo(function (success, res) {
                    if (!success) {
                        reject();
                        return;
                    }
                    var _data = res.data;
                    for (var k in _data) {
                        _this.prizeData[k]['stock'] = _data[k]['stock'];
                        _this.prizeData[k]['spMap'] = _data[k]['spMap'];
                    }
                    ///////////////////////// 查询是否合成过 /////////////////////////
                    NetManager_1.NetManager.ins.queryRecords(function (success, res) {
                        if (!success) {
                            reject();
                            return;
                        }
                        var __data = res.data;
                        for (var _i = 0, __data_1 = __data; _i < __data_1.length; _i++) {
                            var v = __data_1[_i];
                            var prizeId = v.prizeId;
                            if (_this.prizeData.hasOwnProperty(prizeId)) {
                                _this.prizeData[prizeId]['canGet'] = false;
                            }
                        }
                        resolve();
                    });
                    ///////////////////////// 查询是否合成过 /////////////////////////
                }, prizeIds);
                ///////////////////////// 查询库存和需要的道具信息 /////////////////////////
            }, querys);
            ///////////////////////// 查询商店列表 /////////////////////////
        });
    };
    // shop_buy_png    shop_none_png    shop_done_png
    /**
     * 获得道具库存价格信息
     */
    ShopScene.prototype.getPropInfo = function () {
        var _this = this;
        NetManager_1.NetManager.ins.propInfo(function (success, res) {
            if (!success) {
                return;
            }
            var data = {};
            res.data.forEach(function (v) {
                data[v.spId] = {};
                data[v.spId]['stock'] = v.stock;
                data[v.spId]['price'] = v.price;
            });
            var _loop_1 = function (k) {
                var spd = exports.shopSpData[k];
                var d = data[k] || null;
                exports.shopSpData[k].price = d.price;
                exports.shopSpData[k].stock = d.stock;
                _this[spd.name + "Label"].text = "\u6240\u9700\u6B22\u8DA3\u8C46\uFF1A" + (d ? d.price : 0);
                (d && d.stock > 0)
                    ? function () {
                        this[spd.name + "Btn"].source = 'shop_buy_png';
                        this[spd.name + "Btn"].addEventListener(egret.TouchEvent.TOUCH_TAP, this.buyProp, this);
                    }.bind(_this)()
                    : function () {
                        if (this[spd.name + "Btn"].hasEventListener(egret.TouchEvent.TOUCH_TAP)) {
                            this[spd.name + "Btn"].removeEventListener(egret.TouchEvent.TOUCH_TAP, this.buyProp, this);
                        }
                        this[spd.name + "Btn"].source = 'shop_none_png';
                    }.bind(_this)();
            };
            for (var k in exports.shopSpData) {
                _loop_1(k);
            }
        });
    };
    ShopScene.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        GDispatcher_1.GDispatcher.addEvent('docVisible', this.reset, this);
        GDispatcher_1.GDispatcher.addEvent('shopUpdate', this.reset, this);
    };
    ShopScene.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        GDispatcher_1.GDispatcher.removeEvent('docVisible', this.reset, this);
        GDispatcher_1.GDispatcher.removeEvent('shopUpdate', this.reset, this);
    };
    ShopScene.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    Object.defineProperty(ShopScene.prototype, "skinKey", {
        get: function () {
            return 'ShopScene';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ShopScene.prototype, "groupName", {
        get: function () {
            return 'shop';
        },
        enumerable: true,
        configurable: true
    });
    return ShopScene;
}(Scene_1.default));
exports.default = ShopScene;
__reflect(ShopScene.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/Scenes/ShopScene/ShopScene\".ShopScene");
var posArr = [
    [154, 64],
    [154, 64],
    [154, 64],
    [154, 64],
];
// 商店列表
var ShopItem = (function (_super) {
    __extends(ShopItem, _super);
    function ShopItem() {
        var _this = _super.call(this) || this;
        _this.skinName = utils_1.getSkinPath('ShopItem');
        return _this;
    }
    ShopItem.prototype.dataChanged = function () {
        this.mk.visible = !this.data.canGet;
        var title = this.data.name.split('_@_'); // 切分名字和介绍
        this.title.text = title[0];
        this.icon.source = this.data.icon;
        this.stock_label.text = "\u5269\u4F59" + this.data.stock + "\u4EFD";
        this.setNeed();
        this.setBtn();
    };
    // 设置按钮
    ShopItem.prototype.setBtn = function () {
        var _this = this;
        this.btn.anchorOffsetX = 261;
        this.btn.anchorOffsetY = 103;
        this.btn.touchChildren = false;
        this.btn.addEventListener(egret.TouchEvent.TOUCH_TAP, function () {
            if (!_this.data.canGet) {
                UtilsConst_1.showToast("兑换次数已达上限");
                return;
            }
            UtilsConst_1.btnDelay(_this.btn);
            NetManager_1.NetManager.ins.clickLog(getlogItem_1.getlogDpm(21, +_this.data.strategyId.slice(8)));
            egret.Tween.get(_this.btn)
                .to({ scaleX: 0.9, scaleY: 0.9 }, 80, egret.Ease.quadIn)
                .to({ scaleX: 1, scaleY: 1 }, 80, egret.Ease.quadOut)
                .call(function () {
                panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.EXCHANGE_PANEL, _this.data);
            });
        }, this);
    };
    // 显示需要的道具
    ShopItem.prototype.setNeed = function () {
        var _this = this;
        var showList = [];
        for (var spk in this.data['spMap']) {
            showList.push(spk);
        }
        // 设置道具下的label
        var products = Home_1.G_GetHomeDataByKey(Home_1.HOME.PRODUCT);
        showList.forEach(function (v, i) {
            _this[v + "_group"].visible = true;
            _this[v + "_group"].x = 150 + 80 * i;
            _this[v + "_label"].textFlow = [
                {
                    text: products[v].toString(),
                    style: { "textColor": (products[v] < _this.data['spMap'][v]) ? 0xed3330 : 0x855933 }
                },
                { text: '/' + _this.data['spMap'][v], style: { "textColor": 0x855933 } }
            ];
        });
        // 显示+号
        for (var i = 1; i < showList.length; i++) {
            this["add" + i].visible = true;
        }
    };
    return ShopItem;
}(eui.ItemRenderer));
__reflect(ShopItem.prototype, "ShopItem");
//# sourceMappingURL=ShopScene.js.map