"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var sceneTypes_1 = require("../../types/sceneTypes");
var sceneCtrl_1 = require("../../ctrls/sceneCtrl");
var Scene_1 = require("../../views/Scene");
var UtilsConst_1 = require("../../comm/UtilsConst");
var DataManager_1 = require("../../../libs/tw/manager/DataManager");
var NetName_1 = require("../../../libs/tw/enum/NetName");
var panelCtrl_1 = require("../../ctrls/panelCtrl");
var Home_1 = require("../Home");
var Medal_1 = require("./Medal");
var RoomScene = (function (_super) {
    __extends(RoomScene, _super);
    function RoomScene(data) {
        var _this = _super.call(this, data) || this;
        _this.medalsArr = [];
        return _this;
    }
    RoomScene.prototype.start = function () {
        _super.prototype.start.call(this);
        this.initUI();
        if (this.data && this.data.auto) {
            panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.MEDALS_PANEL);
        }
    };
    RoomScene.prototype.initUI = function () {
        this.group.height = 750 / window.innerWidth * window.innerHeight;
        var userInfo = DataManager_1.DataManager.ins.getData(NetName_1.NetName.Get_CONSUMERINFO).data;
        this.nickname.text = ((!userInfo || !userInfo.nickname || (userInfo.nickname == 'null'))
            ? '欢趣使者' : ((userInfo.nickname.length > 4) ? userInfo.nickname.slice(0, 3) + '...' : userInfo.nickname)) + '的小屋';
        var posArr = [
            [25, 68], [81, 68], [136, 68],
            [25, 132], [81, 132], [126, 132],
        ];
        var medal = Home_1.G_GetHomeDataByKey(Home_1.HOME.MEDALS);
        var index = 0;
        var _loop_1 = function (k) {
            (medal[k].count > 0) ? function () {
                var newMedal = new Medal_1.default({ key: k, active: true, index: index });
                newMedal.x = posArr[index][0];
                newMedal.y = posArr[index][1];
                newMedal.scaleX = newMedal.scaleY = 0.3;
                this.medals.addChild(newMedal);
                this.medalsArr.push(newMedal);
            }.bind(this_1)() : 0;
            index++;
        };
        var this_1 = this;
        for (var k in medal) {
            _loop_1(k);
        }
    };
    RoomScene.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        this.medalsArr.forEach(function (v) { return v.destroy(); });
    };
    RoomScene.prototype.getTapEvts = function () {
        return _super.prototype.getTapEvts.call(this).concat([
            [this.backBtn, this.onTouchTap, this],
            [this.medals, this.onTouchTap, this],
            [this.ad, this.onTouchTap, this],
            [this.farm, this.onTouchTap, this],
            [this.market, this.onTouchTap, this],
        ]);
    };
    RoomScene.prototype.onTouchTap = function (e) {
        UtilsConst_1.btnDelay(e.target);
        switch (e.target) {
            case this.backBtn:
                UtilsConst_1.btnDelay(this.backBtn);
                egret.Tween.get(this.backBtn)
                    .to({ scaleX: 1.2, scaleY: 0.8 }, 80)
                    .to({ scaleX: 1, scaleY: 1 }, 80)
                    .call(function () {
                    sceneCtrl_1.default.instance.change(sceneTypes_1.ModuleTypes.MAIN_SCENE);
                });
                // SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE);
                break;
            case this.medals:// 勋章墙
                panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.MEDALS_PANEL);
                break;
            case this.ad:// 广告
                window.location.href = 'https://www.baidu.com/';
                console.log('广告');
                break;
            case this.farm:// 农场相框
                console.log('农场相框');
                break;
            case this.market:// 集市
                window.location.href = 'https://gonghang.activity-1.m.duiba.com.cn/hdtool/index?id=3737984&dbnewopen';
                console.log('集市');
                break;
            default:
                break;
        }
    };
    Object.defineProperty(RoomScene.prototype, "skinKey", {
        get: function () {
            return 'RoomScene';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(RoomScene.prototype, "groupName", {
        get: function () {
            return 'room';
        },
        enumerable: true,
        configurable: true
    });
    return RoomScene;
}(Scene_1.default));
exports.default = RoomScene;
__reflect(RoomScene.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/Scenes/RoomScene/RoomScene\".RoomScene");
//# sourceMappingURL=RoomScene.js.map