"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var TwLang_1 = require("../util/TwLang");
var DataManager_1 = require("./DataManager");
var NetName_1 = require("../enum/NetName");
var ABNetManager_1 = require("../../tc/manager/ABNetManager");
var GTime_1 = require("../../tc/util/GTime");
var GDispatcher_1 = require("../../tc/util/GDispatcher");
var onNotSuccess_1 = require("../../../src/comm/onNotSuccess");
var NetManager = (function (_super) {
    __extends(NetManager, _super);
    function NetManager() {
        var _this = _super.call(this) || this;
        if (_this.isInit) {
            throw Error(TwLang_1.TwLang.lang_001);
        }
        _this.isInit = true;
        return _this;
    }
    Object.defineProperty(NetManager, "ins", {
        get: function () {
            if (!this.instance) {
                this.instance = new NetManager();
            }
            return this.instance;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * 获取用户角色信息
     * @param callback
     * @param {number} roleActivityId 角色id
     * @param {number} type 类型
     */
    NetManager.prototype.getRole = function (callback, roleActivityId, type) {
        if (type === void 0) { type = 1; }
        var net = {
            name: NetName_1.NetName.GET_ROLE,
            uri: '/activityCommon/getRole',
            type: 'get',
            dataType: 'json',
            param: {
                id: roleActivityId,
                type: type
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 活动设置用户角色信息
     * @param callback
     * @param {number} actId  活动id
     * @param {number} type 活动类型 0:插件活动; 1:入库活动
     * @param {string} role 角色信息，不能超过32个字符
     */
    NetManager.prototype.setRole = function (callback, actId, type, role) {
        var net = {
            name: NetName_1.NetName.SET_ROLE,
            uri: '/activityCommon/setRole',
            type: 'post',
            dataType: 'json',
            param: {
                id: actId,
                type: type,
                role: role
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 查询用户现在的剩余积分
     */
    NetManager.prototype.getCredits = function (callback) {
        var net = {
            name: NetName_1.NetName.GET_CREDITS,
            uri: '/ctool/getCredits',
            type: 'get',
            dataType: 'json',
            param: null,
            callback: callback
        };
        this.send(net);
    };
    /**
     * 增加活动免费次数
     * @param callback
     * @param {number} type 1游戏、2活动工具
     * @param {number} count 次数
     * @param {number} validType 如果不传该参数，代表增加的次数是该用户可以永久使用的次数；如果传该参数，代表增加的次数是仅当天可用的，该参数值只能是1
     */
    NetManager.prototype.addTimesForActivity = function (callback, type, count, validType) {
        var activityId;
        if (type == 1) {
            activityId = DataManager_1.DataManager.ins.gameCfgData.gameInfo.oaId;
        }
        else {
            activityId = DataManager_1.DataManager.ins.customCfgData.oaId;
        }
        var param = {
            timestamp: GTime_1.GTime.getTimestamp(),
            addCount: count,
            activityType: "hdtool",
            activityId: activityId
        };
        if (validType) {
            param.validType = validType;
        }
        var net = {
            name: NetName_1.NetName.ADD_TIMES,
            uri: '/activityVist/addTimesForActivity',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback
        };
        this.send(net);
    };
    /**
     * 获取集卡数据
     * @param callback
     * @param {number} collectRuleId 集卡规则ID
     */
    NetManager.prototype.getCollectRule = function (callback, collectRuleId) {
        var net = {
            name: NetName_1.NetName.COLLECT_RULE,
            uri: '/plugin/collectRule/getCollectRule',
            type: 'post',
            dataType: 'json',
            param: {
                collectRuleId: collectRuleId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 获取用户集卡信息接口（返回用户获得最高奖项）
     * @param callback
     * @param {number} collectRuleId 集卡规则ID
     * @param needExtra
     */
    NetManager.prototype.getCollectGoodsInfo = function (callback, collectRuleId, needExtra) {
        if (needExtra === void 0) { needExtra = true; }
        var net = {
            name: NetName_1.NetName.COLLECT_GOODS_INFO,
            uri: '/plugin/collectRule/getCollectGoodsInfo',
            type: 'post',
            dataType: 'json',
            param: {
                collectRuleId: collectRuleId,
                needExtra: needExtra
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 集卡开奖
     * @param callback
     * @param {number} collectRuleId 集卡规则ID
     * @param {number} type 1游戏、2活动工具、其他类型可以不传，发接口actid也不用传
     */
    NetManager.prototype.openCollectGoodsPrize = function (callback, collectRuleId, type) {
        var actId;
        var param;
        if (type == 1) {
            actId = DataManager_1.DataManager.ins.gameCfgData.gameInfo.oaId;
        }
        else if (type == 2) {
            actId = DataManager_1.DataManager.ins.customCfgData.oaId;
        }
        if (type) {
            param = { collectRuleId: collectRuleId, actId: actId };
        }
        else {
            param = { collectRuleId: collectRuleId };
        }
        var net = {
            name: NetName_1.NetName.OPEN_COLLECT,
            uri: '/plugin/collectRule/openCollectGoodsPrize',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback
        };
        this.send(net);
    };
    //--------------------------------------------游戏-----------------------------------------
    /**
     * 游戏基础信息
     */
    NetManager.prototype.getInfo = function (callback) {
        var net = {
            name: NetName_1.NetName.GAME_INFO,
            uri: '/ngame/new/getInfo',
            type: 'get',
            dataType: 'json',
            param: {
                id: DataManager_1.DataManager.ins.gameCfgData.gameInfo.gameId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 夏日活动游戏基础信息
     */
    NetManager.prototype.getSummerInfo = function (callback, rankBaseConfigId) {
        var net = {
            name: NetName_1.NetName.GAME_SUMMERINFO,
            uri: '/summer/getUserActivityInfo',
            type: 'get',
            dataType: 'json',
            param: {
                rankBaseConfigId: rankBaseConfigId,
                isMainActivity: false
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     *  购买鱼钩鱼线道具
     * @param callback
     * @param operatingActivityId 活动oaid
     * @param type 道具类型 0：鱼线 1：鱼钩
     */
    NetManager.prototype.summerBuyProp = function (callback, operatingActivityId, type) {
        var net = {
            name: NetName_1.NetName.GAME_SUMMER_BUYPROP,
            uri: '/summer/buyProp',
            type: 'post',
            dataType: 'json',
            param: {
                operatingActivityId: operatingActivityId,
                type: type
            },
            callback: callback, hideMsg: true
        };
        this.send(net);
    };
    /**
     * 获取鱼钩鱼线数量
     * @param operatingActivityId
     * @param callback
     */
    NetManager.prototype.summerGetToyInfo = function (operatingActivityId, callback) {
        var net = {
            name: NetName_1.NetName.GAME_SUMMER_GET_TOY_INFO,
            uri: '/summer/getToyInfo',
            type: 'get',
            dataType: 'json',
            param: { operatingActivityId: operatingActivityId },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 开始游戏
     * @param callback
     * @param {string} isAgain 是否是再来一次
     * @param {number} credits 主动要求花费多少积分玩游戏
     * @param {number} customizedType xx类型
     */
    NetManager.prototype.doStart = function (callback, isAgain, credits, customizedType) {
        var addUrl = '';
        if (isAgain) {
            addUrl += '?dpm=' + DataManager_1.DataManager.ins.gameGetSubmitResultData.againExposure.dpm;
        }
        var param = {
            id: DataManager_1.DataManager.ins.gameCfgData.gameInfo.gameId,
            oaId: DataManager_1.DataManager.ins.gameCfgData.gameInfo.oaId
        };
        if (credits) {
            param.credits = credits;
        }
        if (customizedType) {
            param.customizedType = customizedType;
        }
        var net = {
            name: NetName_1.NetName.GAME_START,
            uri: '/ngapi/dostart',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback,
            addUrl: addUrl
        };
        this.getToken(net);
    };
    /**
     * 查询开始游戏状态
     * @param callback
     * @param {number} orderId 订单ID
     * @param {Function} pollingCheck 轮询条件 返回true继续轮询
     * @param {number} pollingCount 最大轮询次数
     * @param {number} customizedType
     */
    NetManager.prototype.getStartStatus = function (callback, orderId, pollingCheck, pollingCount, customizedType) {
        if (pollingCount === void 0) { pollingCount = 5; }
        var param = {
            orderId: orderId
        };
        if (customizedType) {
            param.customizedType = customizedType;
        }
        var net = {
            name: NetName_1.NetName.GAME_START_STATUS_NEW,
            uri: '/hdtool/recon/ngame/getNgameStartStatus',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback,
            pollingCount: pollingCount,
            pollingCheck: pollingCheck,
        };
        this.send(net);
    };
    NetManager.prototype.getSummerOrderStatus = function (callback, orderNum, pollingCheck, pollingCount, customizedType) {
        if (pollingCount === void 0) { pollingCount = 5; }
        var param = {
            orderNum: orderNum
        };
        var net = {
            name: NetName_1.NetName.GAME_SUMMER_GET_ORDER_STATUS,
            uri: '/summer/getOrderStatus',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback,
            pollingCount: pollingCount,
            pollingCheck: pollingCheck
        };
        this.send(net);
    };
    /**
     * 复活
     */
    NetManager.prototype.doRevive = function (callback, collectRuleId, itemId) {
        var net = {
            name: NetName_1.NetName.GAME_REVIVE,
            uri: '/summer/doRevive',
            type: 'post',
            dataType: 'json',
            param: {
                collectRuleId: collectRuleId,
                itemId: itemId
            },
            callback: callback,
        };
        this.getToken(net);
    };
    /**
     * 获得复活卡数量
     */
    NetManager.prototype.getReviveCardNum = function (callback, collectRuleId, itemId) {
        var net = {
            name: NetName_1.NetName.GAME_REVIVE_STATUS,
            uri: '/summer/getReviveCardNum',
            type: 'post',
            dataType: 'json',
            param: {
                collectRuleId: collectRuleId,
                itemId: itemId
            },
            callback: callback,
        };
        this.getToken(net);
    };
    /**
     * 猜扑克
     * @param callback
     * @param plugId
     * @param {number} ticketId 订单ID
     * @param {number} prizeId 集卡规则ID
     * @param {number} betting 下注方式 0:大 1:小 2:红 3:黑
     */
    NetManager.prototype.guessPoker = function (callback, plugId, ticketId, prizeId, betting) {
        var net = {
            name: NetName_1.NetName.GAME_GUESS_POKER,
            uri: '/ngapi/guessPoker',
            type: 'post',
            dataType: 'json',
            param: {
                pluginId: plugId,
                ticketId: ticketId,
                prizeId: prizeId,
                betting: betting
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 游戏阶段性数据提交
     * @param callback
     * @param ticketId
     * @param dynamicData 阶段性交互数据
     */
    NetManager.prototype.datapash = function (callback, ticketId, dynamicData) {
        var net = {
            name: NetName_1.NetName.GAME_DATA_PASH,
            uri: '/ngame/new/datapash',
            type: 'post',
            dataType: 'json',
            param: {
                ticketId: ticketId,
                gameId: DataManager_1.DataManager.ins.gameCfgData.gameInfo.id,
                dynamicData: dynamicData
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 提交游戏数据
     *
     * @param callback
     * @param {number} ticketId 订单ID
     * @param {number} score 分数
     * @param {any} gameData 防作弊信息
     * @param {string} submitToken
     * @param {string} dynamicData 行为数据
     * @param {boolean} checkScore 是否校验分数
     * @param {number} customizedType
     */
    NetManager.prototype.gameSubmit = function (callback, ticketId, score, gameData, submitToken, dynamicData, checkScore, customizedType) {
        var sign = this.createSgin(ticketId, score, gameData, submitToken);
        var param = {
            ticketId: ticketId,
            score: score,
            gameData: gameData,
            sgin: sign,
            dynamicData: dynamicData
        };
        if (checkScore) {
            param.checkScore = checkScore;
        }
        if (customizedType) {
            param.customizedType = customizedType;
        }
        var net = {
            name: NetName_1.NetName.GAME_SUBMIT,
            uri: '/ngame/new/submit',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback
        };
        this.send(net);
    };
    /**
     * 生成签名
     * @param {number} ticketId
     * @param {number} score
     * @param {any} gameData
     * @param {string} submitToken
     * @returns {string} 签名
     */
    NetManager.prototype.createSgin = function (ticketId, score, gameData, submitToken) {
        return window['duiba_md5'](ticketId + '' + score + '' + gameData + '' + submitToken);
    };
    /**
     * 游戏结束获取奖品数据
     * @param callback
     * @param {number} orderId 订单ID
     * @param {Function} pollingCheck 轮询条件 返回true继续轮询
     * @param pollingCount
     */
    NetManager.prototype.getSubmitResult = function (callback, orderId, pollingCheck, pollingCount) {
        if (pollingCount === void 0) { pollingCount = 5; }
        var net = {
            name: NetName_1.NetName.GAME_SUBMIT_STATUS,
            uri: '/ngame/new/getSubmitResult',
            type: 'get',
            dataType: 'json',
            param: {
                orderId: orderId
            },
            callback: callback,
            pollingCount: pollingCount,
            pollingCheck: pollingCheck
        };
        this.send(net);
    };
    /**
     * 查看中奖名单
     * @param {boolean} showName 是否返回昵称
     */
    NetManager.prototype.winRanks = function (callback, showName) {
        if (showName === void 0) { showName = false; }
        var net = {
            name: NetName_1.NetName.GAME_RANKS,
            uri: '/ngapi/winranks',
            type: 'post',
            dataType: 'json',
            param: {
                id: DataManager_1.DataManager.ins.gameCfgData.gameInfo.gameId,
                showName: showName
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     *  获取规则
     */
    NetManager.prototype.getRuleNg = function (callback) {
        var net = {
            name: NetName_1.NetName.GAME_RULE,
            uri: '/ngapi/getRuleNg',
            type: 'post',
            dataType: 'html',
            param: {
                id: DataManager_1.DataManager.ins.gameCfgData.gameInfo.gameId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 实时排行榜
     * @param {number} type 0总排行榜 1今日排行榜 2 多游戏总排行榜 3 昨日排行榜
     * @param {number} count 返回榜单长度 最大50
     */
    NetManager.prototype.realtimerank = function (callback, type, count) {
        if (count === void 0) { count = 50; }
        var net = {
            name: NetName_1.NetName.GAME_REAL_TIME_RANK,
            uri: '/ngapi/realtimerank',
            type: 'get',
            dataType: 'json',
            param: {
                id: DataManager_1.DataManager.ins.gameCfgData.gameInfo.gameId,
                count: count,
            },
            callback: callback,
            addUrl: '/' + type
        };
        this.send(net);
    };
    /**
     * 获取成长值
     * @param {number} gametotalid 游戏中心榜单ID
     */
    NetManager.prototype.getUserTotalScore = function (callback, gametotalid) {
        var net = {
            name: NetName_1.NetName.GAME_TOTAL_SCORE,
            uri: '/ngapi/getUserTotalScore',
            type: 'get',
            dataType: 'json',
            param: {
                id: gametotalid
            },
            callback: callback
        };
        this.send(net);
    };
    //--------------------------------------------插件-----------------------------------------
    /**
     * 插件抽奖
     * @param {number} activityId 插件ID
     */
    NetManager.prototype.doJoinPlugDraw = function (callback, activityId, deductCredits) {
        var net = {
            name: NetName_1.NetName.PLUG_DO_JOIN,
            uri: '/activityPlugDrawInfo/doJoinPlugdraw',
            type: 'post',
            dataType: 'json',
            hideMsg: true,
            param: {
                activityId: activityId,
                deductCredits: deductCredits ? deductCredits : false
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 查询插件抽奖订单
     * @param {number} orderId 订单ID
     * @param {number} prizeLevel 开奖等级，暂未开放
     */
    NetManager.prototype.getPlugOrderStatus = function (callback, orderId, pollingCheck, pollingCount, prizeLevel) {
        if (pollingCount === void 0) { pollingCount = 5; }
        var net = {
            name: NetName_1.NetName.PLUG_ORDER_STATUS,
            uri: '/plugin/getOrderStatus',
            type: 'get',
            dataType: 'json',
            hideMsg: true,
            param: {
                orderId: orderId
            },
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        this.send(net);
    };
    /**
     * 查询插件信息
     * @param callback
     * @param plugId
     */
    NetManager.prototype.getPrizeInfo = function (callback, plugId) {
        var net = {
            name: NetName_1.NetName.PLUG_PRIZE_INFO,
            uri: '/activityPlugDrawInfo/getPrizeInfo',
            type: 'post',
            dataType: 'json',
            hideMsg: true,
            param: {
                activityId: plugId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 插件-批量查询奖项信息
     * @param callback
     * @param {string} ids 插件ID 用，间隔
     */
    NetManager.prototype.optionInfo = function (callback, ids) {
        var net = {
            name: NetName_1.NetName.PLUG_OPTION_INFO,
            uri: '/activityPlugin/optionInfo',
            type: 'get',
            dataType: 'json',
            param: {
                ids: ids
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 插件校验解锁纪录
     * @param callback
     * @param {number} id 插件ID
     */
    NetManager.prototype.unblocking = function (callback, id) {
        var net = {
            name: NetName_1.NetName.PLUG_UNBLOCKING,
            uri: 'activityPlugin/unblocking',
            type: 'post',
            dataType: 'json',
            param: {
                id: id
            },
            callback: callback
        };
        this.send(net);
    };
    //--------------------------------------------自定义活动工具-----------------------------------------
    /**
     * 获取基础信息
     */
    NetManager.prototype.ajaxElement = function (callback) {
        var net = {
            name: NetName_1.NetName.CUSTOM_ELEMENT,
            uri: window['CFG'].getElement,
            type: 'post',
            dataType: 'json',
            param: {
                hdType: DataManager_1.DataManager.ins.customCfgData.hdType,
                hdToolId: DataManager_1.DataManager.ins.customCfgData.hdToolId,
                actId: DataManager_1.DataManager.ins.customCfgData.actId,
                preview: DataManager_1.DataManager.ins.customCfgData.preview
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 查询闯关游戏 配置信息
     * @param {number} throughId
     */
    NetManager.prototype.ajaxThroughInfo = function (callback, throughId) {
        if (throughId === void 0) { throughId = 1; }
        var net = {
            name: NetName_1.NetName.CUSTOM_THROUGH_INFO,
            uri: window['CFG'].ajaxThroughInfo,
            type: 'post',
            dataType: 'json',
            param: {
                hdtoolId: DataManager_1.DataManager.ins.customCfgData.hdToolId,
                throughId: 1
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 页面停留时长
     * @param remain
     * @param first
     * @param from
     */
    NetManager.prototype.remainDuration = function (remain, first, from) {
        if (from === void 0) { from = 1; }
        var net = {
            name: 'remainDuration',
            uri: window['duiba'] + '/customActivity/api/remainDuration',
            type: 'get',
            dataType: 'json',
            param: {
                id: DataManager_1.DataManager.ins.customCfgData.hdToolId,
                activityId: DataManager_1.DataManager.ins.customCfgData.actId,
                activityType: 'hdtool',
                remain: remain,
                first: first,
                from: from
            },
            callback: null,
            hideMsg: true
        };
        this.send(net);
    };
    /**
     * 停留时长
     * @param remain 停留时长
     * @param first 是否第一次进入
     * @param from 来源
     */
    NetManager.prototype.remainDurationProjectX = function (remain, first, from) {
        if (from === void 0) { from = 1; }
        var net = {
            name: 'remainDuration',
            uri: '/customActivity/api/remainDuration',
            type: 'get',
            dataType: 'json',
            param: {
                activityId: window['projectId'],
                activityType: '60000',
                remain: remain,
                first: first,
                from: from
            },
            callback: null,
            hideMsg: true
        };
        NetManager.ins.send(net);
    };
    /**
     * 活动工具抽奖
     * @param {number} collectRuleId 集卡规则ID，活动与集卡规则关联才能获得发卡资格
     */
    NetManager.prototype.doJoin = function (callback, collectRuleId) {
        var param = {
            activityId: DataManager_1.DataManager.ins.customCfgData.actId,
            oaId: DataManager_1.DataManager.ins.customCfgData.oaId
        };
        if (collectRuleId) {
            param.collectRuleId = collectRuleId;
        }
        var net = {
            name: NetName_1.NetName.DO_JOIN_DATA,
            uri: "/hdtool/recon/doJoin",
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback,
        };
        this.getToken(net);
    };
    /**
     * 活动工具查询订单结果
     * @param orderId
     */
    NetManager.prototype.getCustomOrderStatus = function (callback, orderId, pollingCheck, pollingCount) {
        if (pollingCount === void 0) { pollingCount = 5; }
        var net = {
            name: NetName_1.NetName.CUSTOM_ORDER_STATUS,
            uri: window['CFG'].quireOrder,
            type: 'post',
            dataType: 'json',
            param: {
                orderId: orderId
            },
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        this.send(net);
    };
    /**
     * 获取抽奖前置信息
     * @param {string} orderId 订单ID
     */
    NetManager.prototype.getOrderInfo = function (callback, orderId, showMsg) {
        if (showMsg === void 0) { showMsg = true; }
        var net = {
            name: NetName_1.NetName.CUSTOM_ORDER_INFO,
            uri: window['CFG'].gameGetOrder,
            type: 'post',
            dataType: 'json',
            param: {
                orderId: orderId
            },
            callback: callback,
            hideMsg: true
        };
        this.send(net);
    };
    /**
     * 前置开奖提交
     * @param {string} orderId 订单ID
     * @param {string} facePrice 前置开奖所需分值
     */
    NetManager.prototype.beforSubmit = function (callback, orderId, facePrice) {
        var net = {
            name: NetName_1.NetName.CUSTOM_BEFOR_SUBMIT,
            uri: window['CFG'].gameSubmit,
            type: 'post',
            dataType: 'json',
            param: {
                orderId: orderId,
                facePrice: facePrice
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 答题提交
     */
    NetManager.prototype.questionSubmit = function () {
    };
    /**
     * 闯关游戏提交
     */
    NetManager.prototype.throughSubmit = function (callback, orderId) {
        var net = {
            name: NetName_1.NetName.CUSTOM_THROUGH_SUBMIT,
            uri: window['CFG'].throughSubmit,
            type: 'post',
            dataType: 'json',
            param: {
                orderId: orderId
            },
            callback: callback
        };
        this.send(net);
    };
    //--------------------------------------------养成-----------------------------------------
    /**
     * 宠物领养
     * @param {number} activityId 宠物养成活动ID
     * @param {string} petName 宠物名称
     */
    NetManager.prototype.petAdopte = function (callback, activityId, petName) {
        var net = {
            name: NetName_1.NetName.PET_ADOPTE,
            uri: '/signpet/adopte',
            type: 'post',
            dataType: 'json',
            param: {
                activityId: activityId,
                petName: petName
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 宠物状态刷新
     * @param callback
     * @param {number} petId 宠物ID
     * @param activityId
     */
    NetManager.prototype.getPetStatus = function (callback, petId, activityId) {
        var net = {
            name: NetName_1.NetName.PET_STATUS,
            uri: '/signpet/status',
            type: 'get',
            dataType: 'json',
            param: {
                petId: petId,
                activityId: activityId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 宠物喂食
     * @param {number} petId 宠物ID
     * @param {number} feedNum 喂食数量
     */
    NetManager.prototype.petFeed = function (callback, petId, feedNum, activityId) {
        var net = {
            name: NetName_1.NetName.PET_FEED,
            uri: '/signpet/feed',
            type: 'post',
            dataType: 'json',
            param: {
                petId: petId,
                feedNum: feedNum,
                activityId: activityId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 获取宠物信息
     * @param callback
     * @param activityId
     */
    NetManager.prototype.getPetInfo = function (callback, activityId) {
        var net = {
            name: NetName_1.NetName.PET_INFO,
            uri: '/signpet/getPetInfo',
            type: 'get',
            dataType: 'json',
            param: {
                activityId: activityId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 签到信息查询
     * @param {Function} callback
     * @param {number} signActivityId 签到活动ID
     */
    NetManager.prototype.getSignInfo = function (callback, signActivityId) {
        var net = {
            name: NetName_1.NetName.SIGN_INFO,
            uri: '/signactivity/getSignInfo',
            type: 'post',
            dataType: 'json',
            param: {
                signActivityId: signActivityId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 签到接口
     * @param {Function} callback
     * @param {number} signActivityId 签到活动ID
     * @param {number} activityId 插件活动ID，用于加抽奖次数，不传则使用签到身上配置的插件活动ID，否则不加抽奖次数
     */
    NetManager.prototype.doSign = function (callback, signActivityId, activityId) {
        var data;
        if (activityId) {
            data = {
                id: signActivityId,
                activityId: activityId
            };
        }
        else {
            data = {
                id: signActivityId
            };
        }
        var net = {
            name: NetName_1.NetName.SIGN_DO_SIGN,
            uri: '/signactivity/doSign',
            type: 'post',
            dataType: 'json',
            param: data,
            callback: callback
        };
        this.send(net);
    };
    /**
     * 签到结果查询
     * @param callback
     * @param logId    签到流水ID
     */
    NetManager.prototype.getSignResult = function (callback, logId, pollingCheck, pollingCount) {
        if (pollingCount === void 0) { pollingCount = 10; }
        var data = {
            logId: logId
        };
        var net = {
            name: NetName_1.NetName.GET_SIGN_RESULT,
            uri: '/signactivity/getSignResult',
            type: 'post',
            dataType: 'json',
            param: data,
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        this.send(net);
    };
    /**
     * 道具展示接口
     * @param callback
     * @param {number} actId 宠物活动ID
     */
    NetManager.prototype.getToys = function (callback, actId) {
        var net = {
            name: NetName_1.NetName.PET_TOYS,
            uri: '/signpet/addition/getToys',
            type: 'get',
            dataType: 'json',
            param: {
                actId: actId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 道具兑换接口
     * @param callback
     * @param {number} toyId 道具id
     * @param {number} credits 兑换所需积分
     */
    NetManager.prototype.toyExchange = function (callback, toyId, credits) {
        var net = {
            name: NetName_1.NetName.PET_TOY_EXCHANGE,
            uri: '/signpet/addition/toyExchange',
            type: 'post',
            dataType: 'json',
            param: {
                toyId: toyId,
                credits: credits
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 道具使用接口
     * @param callback
     * @param {string} identifier 道具唯一标识
     * @param {number} petId 宠物id
     */
    NetManager.prototype.toyUse = function (callback, identifier, petId) {
        var net = {
            name: NetName_1.NetName.PET_TOY_USE,
            uri: '/signpet/addition/toyUse',
            type: 'post',
            dataType: 'json',
            param: {
                identifier: identifier,
                petId: petId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 收取礼物接口
     * @param callback
     * @param {number} giftId 礼物id
     * @param giftNum
     * @param {string} giftName 礼物名称
     * @param {string} giftDesc 礼物描述
     * @param {number} giftType 礼物类型 1：用户自定义， 2：食物
     * @param {string} giftLink 礼物链接
     * @param {number} petId 宠物id
     */
    NetManager.prototype.collect = function (callback, giftId, giftNum, giftName, giftDesc, giftType, giftLink, petId) {
        var net = {
            name: NetName_1.NetName.PET_COLLECT,
            uri: '/signpet/addition/collect',
            type: 'post',
            dataType: 'json',
            param: {
                giftId: giftId,
                giftNum: giftNum,
                giftName: giftName,
                giftDesc: giftDesc,
                giftType: giftType,
                giftLink: giftLink,
                petId: petId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 群内喂食排行榜
     * @param callback
     * @param {number} petId 宠物id
     * @param {number} topNum 排行榜显示top个数
     * @param pollingCheck
     * @param pollingCount
     */
    NetManager.prototype.getRankList = function (callback, petId, topNum, pollingCheck, pollingCount) {
        var net = {
            name: NetName_1.NetName.PET_GET_RANK_LIST,
            uri: '/signpet/getRankList',
            type: 'get',
            dataType: 'json',
            param: {
                petId: petId,
                topNum: topNum,
                pollingCheck: pollingCheck,
                pollingCount: pollingCount
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 查询待领取粮食
     * @param callback
     */
    NetManager.prototype.getFoodPiles = function (callback) {
        var net = {
            name: NetName_1.NetName.PET_GET_FOOD_PILES,
            uri: '/signpet/getFoodPiles',
            type: 'get',
            dataType: 'json',
            param: {},
            callback: callback
        };
        this.send(net);
    };
    /**
     * 待领取粮食收取
     * @param callback
     * @param {number} id 待领取粮食主键ID
     * @param {number} activityId 活动id
     * @param petId
     */
    NetManager.prototype.collectFood = function (callback, id, activityId, petId) {
        var net = {
            name: NetName_1.NetName.PET_COLLECT_FOOD,
            uri: '/signpet/collectFood',
            type: 'post',
            dataType: 'json',
            param: {
                id: id,
                activityId: activityId,
                petId: petId
            },
            callback: callback
        };
        this.send(net);
    };
    //--------------------------------------------------------------------外来宠物养成--------------------------------------------------------------------------
    /**
     * 活动主信息接口
     * @param callback
     * @param activityId
     */
    NetManager.prototype.getHomeInfo = function (callback, activityId) {
        var net = {
            name: NetName_1.NetName.PETS_GET_HOME_INFO,
            uri: '/sign/wander/getHomeInfo',
            type: 'get',
            dataType: 'json',
            param: {
                activityId: activityId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 商店道具接口
     * @param callback
     * @param actId
     * @param actType    2-日历 4-养成 5-契约 6-外来宠物
     * @param toyType   1-状态 2-装饰 3-功能 4-食物 5-玩具
     * @param petId
     */
    NetManager.prototype.getActToys = function (callback, actId, actType, toyType, petId) {
        var net = {
            name: NetName_1.NetName.PETS_GET_ACT_TOYS,
            uri: '/sign/addition/getActToys',
            type: 'get',
            dataType: 'json',
            param: {
                actId: actId,
                actType: actType,
                toyType: toyType,
                petId: petId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 外来宠物养成-道具兑换接口
     * @param callback
     * @param {number} toyId 道具id
     * @param {number} count 购买数量
     */
    NetManager.prototype.toyExchanges = function (callback, toyId, count) {
        var param = {};
        if (count) {
            param = {
                toyId: toyId,
                count: count
            };
        }
        else {
            param = {
                toyId: toyId
            };
        }
        var net = {
            name: NetName_1.NetName.PETS_TOY_EXCHANGE,
            uri: '/sign/addition/toyExchange',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback
        };
        this.send(net);
    };
    /**
     * 道具使用接口
     * @param callback
     * @param {number} actId 活动id
     * @param {any[]} toyList 使用的道具列表 [{identifier:'道具标识', position:'投放位置'}, {identifier:'道具标识', position:'投放位置'}]
     */
    NetManager.prototype.useToy = function (callback, actId, toyList) {
        var net = {
            name: NetName_1.NetName.PETS_USE_TOYS,
            uri: '/sign/addition/useToy',
            type: 'post',
            dataType: 'json',
            param: {
                actId: actId,
                toyList: JSON.stringify(toyList)
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 道具使用携程
     * @param callback
     * @param activityId
     * @param identifier
     * @param petId
     */
    NetManager.prototype.toyUse_xiecheng = function (callback, activityId, identifier, petId) {
        var net = {
            name: NetName_1.NetName.PETS_USE_TOYS_XCH,
            uri: '/sign/addition/toyUse',
            type: 'post',
            dataType: 'json',
            param: {
                activityId: activityId,
                identifier: identifier,
                petId: petId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 已购买的道具接口
     * @param callback
     * @param petId     宠物id 没有传0
     * @param toyType   1-状态 2-装饰 3-功能 4-食物 5-玩具
     */
    NetManager.prototype.getUserToys = function (callback, petId, toyType) {
        var net = {
            name: NetName_1.NetName.PETS_GET_USER_TOYS,
            uri: '/sign/addition/getUserToys',
            type: 'get',
            dataType: 'json',
            param: {
                petId: petId,
                toyType: toyType
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 粮食收取
     * @param callback
     * @param actId     活动id
     * @param ids       收取粮食堆的主键id列表[1,2,3,4]
     */
    NetManager.prototype.batchollectFood = function (callback, actId, ids) {
        var net = {
            name: NetName_1.NetName.PETS_BATCHOLLECT_FOOD,
            uri: '/sign/addition/batchollectFood',
            type: 'post',
            dataType: 'json',
            param: {
                ids: JSON.stringify(ids),
                actId: actId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 来访统计
     * @param callback
     * @param actId
     */
    NetManager.prototype.visitStatistics = function (callback, actId) {
        var net = {
            name: NetName_1.NetName.PETS_VISI_STATISTICS,
            uri: '/sign/wander/visitStatistics',
            type: 'get',
            dataType: 'json',
            param: {
                actId: actId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 动态信息列表
     * @param callback
     * @param actId         活动id
     * @param showNum       显示条数
     */
    NetManager.prototype.getVisitInfo = function (callback, actId, showNum) {
        var net = {
            name: NetName_1.NetName.PETS_GET_VISIT_INFO,
            uri: '/sign/wander/getVisitInfo',
            type: 'get',
            dataType: 'json',
            param: {
                showNum: showNum,
                actId: actId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 到访记录详情
     * @param callback
     * @param actId ：活动id
     * @param identifier ：宠物唯一标识
     */
    NetManager.prototype.visitDetail = function (callback, actId, identifier) {
        var net = {
            name: NetName_1.NetName.PETS_VISIT_DETAIL,
            uri: '/sign/wander/visitDetail',
            type: 'get',
            dataType: 'json',
            param: {
                actId: actId,
                identifier: identifier
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 礼物收取
     * @param callback
     * @param recordId 礼物记录ID
     */
    NetManager.prototype.collectGiftRecord = function (recordId, callback) {
        var net = {
            name: NetName_1.NetName.PETS_COLLECT_GIFT_RECORD,
            uri: '/sign/wander/collectGiftRecord',
            type: 'post',
            dataType: 'json',
            param: {
                recordId: recordId
            },
            callback: callback
        };
        this.send(net);
    };
    //-----------------------------------------------------------------订制接口-----------------------------------------------------------------
    // /**
    //  * 收入明细
    //  * @param callback 
    //  * @param activityId 活动ID
    //  */
    // public getProfitDetail(callback: Function, activityId: number): void {
    //     const net: INetData = {
    //         name: NetName.GET_PROFIT_DETAIL,
    //         uri: '/sign/custom/getProfitDetail',
    //         type: 'get',
    //         dataType: 'json',
    //         param: {
    //             activityId: activityId
    //         },
    //         callback: callback
    //     };
    //     this.send(net);
    // }
    /**
     * 宠物出行
     * @param callback
     * @param activityId 活动ID
     * @param petId 宠物ID
     * @param mapType 地图类型，1：中国，2：亚洲，3：欧洲
     */
    NetManager.prototype.petGoout = function (callback, activityId, petId, mapType) {
        var net = {
            name: NetName_1.NetName.PET_GOOUT,
            uri: '/signpet/ctrip/goout',
            type: 'post',
            dataType: 'json',
            param: {
                activityId: activityId,
                petId: petId,
                mapType: mapType
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 宠物出行结果查询
     * @param callback
     * @param activityId 活动ID
     * @param petId 宠物ID
     * @param recordId 出行ID
     * @param {Function} pollingCheck 轮询条件 返回true继续轮询
     * @param {number} pollingCount 最大轮询次数
     */
    NetManager.prototype.petGooutResult = function (callback, activityId, petId, recordId, pollingCheck, pollingCount) {
        if (pollingCount === void 0) { pollingCount = 5; }
        var net = {
            name: NetName_1.NetName.PET_GOOUT_RESULT,
            uri: '/signpet/ctrip/goout/result',
            type: 'get',
            dataType: 'json',
            param: {
                activityId: activityId,
                petId: petId,
                recordId: recordId
            },
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        this.send(net);
    };
    /**
     * 携程宠物出行奖励查询
     * @param callback
     * @param activityId 活动ID
     * @param petId 宠物ID
     */
    NetManager.prototype.getPetGooutReward = function (callback, activityId, petId) {
        var net = {
            name: NetName_1.NetName.PET_GOOUT_REWARD,
            uri: '/signpet/ctrip/goout/reward',
            type: 'get',
            dataType: 'json',
            param: {
                activityId: activityId,
                petId: petId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 道具兑换接口---携程
     * @param callback
     * @param activityId 活动id
     * @param petId 宠物id
     * @param toyId 道具id
     * @param count 道具数量
     */
    NetManager.prototype.toyExchange_xc = function (callback, activityId, petId, toyId, count) {
        var net = {
            name: NetName_1.NetName.TOY_EXCHANGES_DATA_XC,
            uri: '/sign/addition/toy/prizeExchange',
            type: 'post',
            dataType: 'json',
            param: {
                activityId: activityId,
                petId: petId,
                toyId: toyId,
                count: count
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 主页-书旗小七
     */
    NetManager.prototype.getIndex = function (callback, activityId, refreshReading, shareCode) {
        var param;
        if (shareCode) {
            param = {
                activityId: activityId,
                refreshReading: refreshReading,
                shareCode: shareCode,
            };
        }
        else {
            param = {
                activityId: activityId,
                refreshReading: refreshReading
            };
        }
        var net = {
            name: NetName_1.NetName.GET_INDEX,
            uri: '/customActivity/shuqi/pet/index',
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback
        };
        this.send(net);
    };
    /**
     * 主页-书旗小七-02、游戏区数据接口
     */
    NetManager.prototype.getGameZone = function (callback, activityId) {
        var param;
        param = {
            activityId: activityId
        };
        var net = {
            name: NetName_1.NetName.GET_GAMEZONE,
            uri: '/customActivity/shuqi/pet/gameZone',
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback
        };
        this.send(net);
    };
    /**
     * 召唤狗狗-云集-汪星球游戏
     * @param callback
     * @param level
     * @param activityId
     * @param holeIndex
     */
    NetManager.prototype.getSummon = function (callback, level, activityId, holeIndex) {
        var net = {
            name: NetName_1.NetName.GET_SUMMON,
            uri: '/customActivity/shuqi/pet/callPet',
            type: 'post',
            dataType: 'json',
            param: {
                level: level,
                activityId: activityId,
                holeIndex: holeIndex
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 变更位置-云集-汪星球游戏
     * @param callback
     * @param id
     * @param holeIndex
     * @param activityId
     */
    NetManager.prototype.getLocation = function (callback, id, holeIndex, activityId) {
        var net = {
            name: NetName_1.NetName.GET_LOCATION,
            uri: '/customActivity/shuqi/pet/movePet',
            type: 'post',
            dataType: 'json',
            param: {
                id: id,
                holeIndex: holeIndex,
                activityId: activityId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 变更位置-云集-汪星球游
     * @param callback
     * @param formId
     * @param toId
     * @param activityId
     */
    NetManager.prototype.getMerge = function (callback, formId, toId, activityId) {
        var net = {
            name: NetName_1.NetName.GET_MERGE,
            uri: '/customActivity/shuqi/pet/mergePet',
            type: 'post',
            dataType: 'json',
            param: {
                activityId: activityId,
                fromId: formId,
                toId: toId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 回收狗狗-云集-汪星球游戏
     * @param callback
     * @param id
     * @param activityId
     */
    NetManager.prototype.getRecycle = function (callback, id, activityId) {
        var net = {
            name: NetName_1.NetName.GET_RECYCLE,
            uri: '/customActivity/shuqi/pet/recoverPet',
            type: 'post',
            dataType: 'json',
            param: {
                id: id,
                activityId: activityId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 获取阅读状态
     * @param callback
     * @param activityId
     * @param orderId
     * @param pollingCheck
     * @param pollingCount
     * @param customizedType
     */
    NetManager.prototype.getRewardStatus = function (callback, activityId, orderId, pollingCheck, pollingCount, customizedType) {
        if (pollingCount === void 0) { pollingCount = 10; }
        var param = {
            orderId: orderId,
            activityId: activityId
        };
        var net = {
            name: NetName_1.NetName.GET_REWARD,
            uri: '/customActivity/shuqi/pet/getReward',
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback,
            pollingCount: pollingCount,
            pollingCheck: pollingCheck
        };
        this.send(net);
    };
    //刷新阅读、签到状态
    NetManager.prototype.refreshReward = function (callback, activityId) {
        var net = {
            name: NetName_1.NetName.REFRESH_REWARD,
            uri: '/customActivity/shuqi/pet/refreshReward',
            type: 'post',
            dataType: 'json',
            param: {
                activityId: activityId
            },
            callback: callback
        };
        this.send(net);
    };
    //签到成功
    NetManager.prototype.signSuccess = function (callback, activityId) {
        var net = {
            name: NetName_1.NetName.SING_SUCCESS,
            uri: '/customActivity/shuqi/pet/signSuccess',
            type: 'post',
            dataType: 'json',
            param: {
                activityId: activityId
            },
            callback: callback
        };
        this.send(net);
    };
    ///////////////////////////////// 浦发中秋 /////////////////////////////////
    /**
     *  获取奖项
     */
    NetManager.prototype.getOptions = function (callback) {
        var net = {
            name: NetName_1.NetName.GAME_OPTIONS,
            uri: '/ngapi/getOptions',
            type: 'post',
            dataType: 'json',
            param: {
                id: DataManager_1.DataManager.ins.customCfgData.actId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 查询排行榜信息
     * @param callback 回调函数
     * @param rankId 排行榜id
     * @param activityId 活动id
     * @param needPreviousPeriod 是否需要上期排行榜
     */
    NetManager.prototype.getRankInfo = function (callback, rankId, activityId, needPreviousPeriod) {
        var net = {
            name: NetName_1.NetName.RANK_INFO,
            uri: '/hdtool/rank/rankInfo',
            type: 'get',
            dataType: 'json',
            param: {
                rankId: rankId,
                activityId: activityId,
                needPreviousPeriod: needPreviousPeriod,
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 浦发中秋排行榜
     * @param callback
     * @param rankId 排行榜id
     * @param activityId 活动id
     * @param needPreviousPeriod 是否需要上期排行榜数据 是：true 否：false ,默认true
     * @param pageNo 默认0
     * @param pageSize 默认20
     */
    NetManager.prototype.getRecentRankListNew = function (callback, rankId, activityId, needPreviousPeriod, pageNo, pageSize) {
        var net = {
            name: NetName_1.NetName.RANK_NEW_LIST,
            uri: '/hdtool/rank/recentRankListNew',
            type: 'get',
            dataType: 'json',
            param: {
                rankId: rankId,
                activityId: activityId,
                needPreviousPeriod: needPreviousPeriod,
                pageNo: pageNo,
                pageSize: pageSize
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 获取上期中奖信息
     * @param callback 回调函数
     * @param rankId 排行榜id
     * @param activityId 活动id
     */
    NetManager.prototype.getOpenPrizeInfo = function (callback, rankId, activityId) {
        var net = {
            name: NetName_1.NetName.GET_PERIOD_PRIZE_INFO,
            uri: '/hdtool/rank/getOpenPrizeInfo',
            type: 'get',
            dataType: 'json',
            param: {
                rankId: rankId,
                activityId: activityId,
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 分享加次数接口
     * @param callback 回调函数
     * @param timestamp 时间戳
     * @param activityId 插件/活动ID
     * @param validType 1:当天有效，默认永久
     * @param addCount
     * @param openShareLimitInDay 是否打开分享次数单日限制，默认为false
     * @param shareLimitInDay 每日限制的调用次数，默认为1
     */
    NetManager.prototype.addTimesForShare = function (callback, timestamp, activityId, validType, addCount, openShareLimitInDay, shareLimitInDay) {
        var net = {
            name: NetName_1.NetName.GET_PERIOD_PRIZE_INFO,
            uri: '/activityVist/addTimesForShare',
            type: 'post',
            dataType: 'json',
            param: {
                timestamp: timestamp,
                activityId: activityId,
                addCount: addCount,
                openShareLimitInDay: openShareLimitInDay,
                shareLimitInDay: shareLimitInDay,
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 获取订单状态
     * @param callback 回调很熟
     * @param orderNum
     * @param pollingCheck 轮询回调函数
     * @param pollingCount 轮询次数
     * @param customizedType
     */
    NetManager.prototype.getOrderStatus = function (callback, orderNum, pollingCheck, pollingCount, customizedType) {
        if (pollingCount === void 0) { pollingCount = 5; }
        var param = {
            orderId: orderNum
        };
        var net = {
            name: NetName_1.NetName.GET_ORDER_STATUS,
            uri: '/hdtool/recon/getOrderStatus',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback,
            pollingCount: pollingCount,
            pollingCheck: pollingCheck,
            hideMsg: true,
        };
        this.send(net);
    };
    /**
     * 游戏结束提交
     * @param callback 回调函数
     * @param orderId 订单id
     * @param score 分数
     */
    NetManager.prototype.GameSubmit = function (callback, orderId, score) {
        var sign = this.createSgin(orderId, score, "[]", DataManager_1.DataManager.ins.getData(NetName_1.NetName.GAME_START_STATUS_NEW).data.submitToken);
        var net = {
            name: NetName_1.NetName.GAME_SUBMIT_NEW,
            uri: '/hdtool/recon/ngame/ngameSubmit',
            type: 'post',
            dataType: 'json',
            param: {
                orderId: orderId,
                score: score,
                gameData: "[]",
                sgin: sign,
                dynamicData: JSON.stringify("{t2:" + new Date().getTime() + "}"),
                rankId: window["rankId"]
            },
            callback: callback
        };
        this.send(net);
    };
    ///////////////////////////////// 新游戏 /////////////////////////////////
    //阅读任务
    NetManager.prototype.reportToRead = function (callback, activityId) {
        var net = {
            name: NetName_1.NetName.PEPORT_TO_READ,
            uri: '/customActivity/shuqi/pet/reportToRead',
            type: 'post',
            dataType: 'json',
            param: {
                activityId: activityId
            },
            callback: callback
        };
        this.send(net);
    };
    //阅读任务
    NetManager.prototype.uploadNickName = function (callback, activityId, nickName) {
        var net = {
            name: NetName_1.NetName.UPLOAD_NICKNAME,
            uri: '/customActivity/shuqi/pet/uploadNickName',
            type: 'post',
            dataType: 'json',
            param: {
                activityId: activityId,
                nickName: nickName
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 获取队伍信息-云集-汪星球游戏
     */
    NetManager.prototype.getTeamInfo = function (callback, activityId) {
        var net = {
            name: NetName_1.NetName.GET_TEAMINFO,
            uri: '/customActivity/yunji/dog/teamInfo',
            type: 'get',
            dataType: 'json',
            param: {
                activityId: activityId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 获取队伍信息-云集-汪星球游戏
     */
    NetManager.prototype.getShareCode = function (callback, activityId, activityType) {
        var net = {
            name: NetName_1.NetName.GET_SHARECODE,
            uri: '/activtyShareCode/getShareCode',
            type: 'get',
            dataType: 'json',
            param: {
                activityId: activityId,
                activityType: activityType,
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 获取队伍信息-云集-汪星球游戏
     */
    NetManager.prototype.joinTeam = function (callback, shareCode, activityId) {
        var net = {
            name: NetName_1.NetName.JOINTEAM,
            uri: '/customActivity/yunji/dog/join',
            type: 'post',
            dataType: 'json',
            param: {
                shareCode: shareCode,
                activityId: activityId,
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 获取商店信息-云集养狗
     * @param callback
     * @param activityId
     */
    NetManager.prototype.shopYuji = function (callback, activityId) {
        var net = {
            name: NetName_1.NetName.SHOP_YUNJI,
            uri: '/customActivity/yunji/dog/shop',
            type: 'get',
            dataType: 'json',
            param: {
                activityId: activityId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 查询购买道具接口（携程）
     * @param callback
     * @param activityId 活动id
     * @param petId 宠物id
     * @param orderId 订单id
     * @param pollingCheck
     * @param pollingCount
     */
    NetManager.prototype.exchangeResult = function (callback, activityId, petId, orderId, pollingCheck, pollingCount) {
        if (pollingCount === void 0) { pollingCount = 10; }
        var net = {
            name: NetName_1.NetName.EXCHANGE_RECSULT,
            uri: '/sign/addition/toy/prizeExchange/result',
            type: 'get',
            dataType: 'json',
            param: {
                activityId: activityId,
                petId: petId,
                orderId: orderId
            },
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        this.send(net);
    };
    /**
     * 获取用户积分流水明细
     * @param callback
     * @param appId appId
     * @param uid 用户Id
     * @param orderStatus 订单状态：待确认／已完成（process／finish）
     * @param rowId 当前页
     * @param max 每页条数
     */
    NetManager.prototype.weOrder = function (callback, appId, uid, rowId, max, orderStatus) {
        var _this = this;
        if (orderStatus === void 0) { orderStatus = "success"; }
        var net = {
            name: NetName_1.NetName.WE_ORDER,
            uri: (window['weUrl'] ? window['weUrl'] : '') + '/duiba/weOrder',
            type: 'get',
            dataType: 'json',
            param: {
                appId: appId,
                uid: uid,
                rowId: rowId,
                max: max,
                orderStatus: orderStatus
            },
            callback: callback
        };
        var gTime = '?_=' + GTime_1.GTime.getTimestamp();
        var realUrl = net.uri;
        if (realUrl.indexOf('?') != -1) {
            gTime = '&_=' + GTime_1.GTime.getTimestamp();
        }
        //url加参数等特殊需求（例如再玩一次需要在dostart接口的url上加埋点）
        if (net.addUrl) {
            realUrl += net.addUrl;
        }
        window['$'].ajax({
            type: net.type,
            // url: realUrl + gTime,
            url: realUrl,
            dataType: net.dataType,
            data: net.param,
            async: true,
            xhrFields: {
                withCredentials: false
            },
            crossDomain: true,
            cache: false,
            success: function (result) {
                _this.onResponse(net, result);
            },
            error: function (message) {
                _this.onError(net);
            }
        });
    };
    /**
     * 获取token
     * @param net
     */
    NetManager.prototype.getToken = function (net) {
        var _this = this;
        if (window['getDuibaToken']) {
            window['getDuibaToken'](function (tokenObj) {
                net.param.token = tokenObj.token;
                _this.send(net);
            }, function (key, messageObj) {
                _this.onError(net);
            });
        }
        else {
            this.send(net);
        }
    };
    /**
     * 查询我的奖品记录
     * @param callback
     * @param {number} page 当前页数
     */
    NetManager.prototype.getRecord = function (callback, page) {
        var _this = this;
        var net = {
            name: NetName_1.NetName.GET_RECORD,
            uri: (window['recordUrl'] ? window['recordUrl'] : '') + '/Crecord/getRecord',
            type: 'get',
            dataType: 'json',
            param: {
                page: page
            },
            callback: callback
        };
        var gTime = '?_=' + GTime_1.GTime.getTimestamp();
        var realUrl = net.uri;
        if (realUrl.indexOf('?') != -1) {
            gTime = '&_=' + GTime_1.GTime.getTimestamp();
        }
        //url加参数等特殊需求（例如再玩一次需要在dostart接口的url上加埋点）
        if (net.addUrl) {
            realUrl += net.addUrl;
        }
        window['$'].ajax({
            type: net.type,
            // url: realUrl + gTime,
            url: realUrl,
            dataType: net.dataType,
            data: net.param,
            async: true,
            xhrFields: {
                withCredentials: true
            },
            crossDomain: true,
            cache: false,
            success: function (result) {
                _this.onResponse(net, result);
            },
            error: function (message) {
                _this.onError(net);
            }
        });
    };
    /**
     * 推啊曝光埋点(福袋)
     * @param {IExposureData} exposure
     */
    NetManager.prototype.spmshow = function (exposure) {
        var domain = (exposure.domain ? exposure.domain : '') + '/engine/';
        var net = {
            name: 'spmshow',
            uri: domain + 'spmshow',
            type: 'get',
            dataType: 'jsonp',
            param: exposure,
            callback: null,
            hideMsg: true
        };
        this.send(net);
    };
    /**
     * 推啊点击埋点(福袋)
     * @param {IExposureData} exposure
     */
    NetManager.prototype.spmclick = function (exposure) {
        var domain = (exposure.domain ? exposure.domain : '') + '/engine/';
        var net = {
            name: 'spmclick',
            uri: domain + 'spmclick',
            type: 'get',
            dataType: 'jsonp',
            param: exposure,
            callback: null,
            hideMsg: true
        };
        this.send(net);
    };
    /**
     * 兑吧点击埋点
     * @param {IExposureData} exposure
     */
    NetManager.prototype.clickLog = function (exposure) {
        var net = {
            name: 'clickLog',
            uri: '/log/click',
            type: 'get',
            dataType: 'jsonp',
            param: exposure,
            callback: null,
            hideMsg: true
        };
        this.send(net);
    };
    /**
     * 兑吧曝光埋点
     * @param {IExposureData} exposure
     */
    NetManager.prototype.showLog = function (exposure) {
        var net = {
            name: 'showLog',
            uri: exposure.domain + '/exposure/standard',
            type: 'get',
            dataType: 'jsonp',
            param: exposure,
            callback: null,
            hideMsg: true
        };
        this.send(net);
    };
    /**
     * 消息响应
     * @param net
     * @param result 结果
     */
    NetManager.prototype.onResponse = function (net, result) {
        var _this = this;
        //数据处理
        var data = DataManager_1.DataManager.ins.updateData(net.name, result, net.param);
        if (net.pollingCheck) {
            console.log('result=====', result);
            console.log('data=====', data);
        }
        //接口成功
        if (net.pollingCount && net.pollingCheck(data)) {
            net.pollingCount -= 1;
            //轮询接口特殊处理
            setTimeout(function () {
                _this.send(net);
            }, 500);
        }
        else if (net.callback) {
            if (net.pollingCheck && !net.pollingCount && net.pollingCheck(data)) {
                net.callback(false, 'pollingFaild');
            }
            else {
                net.callback(data.success, data || result);
            }
        }
        if (!data.success && !net.hideMsg) {
            GDispatcher_1.GDispatcher.dispatchEvent(ABNetManager_1.ABNetManager.ERROR, net, result.message || result.desc || result.msg, result);
            onNotSuccess_1.onNotSuccess(data, net.name);
        }
    };
    /**
     * 通讯底层错误
     * @param net
     */
    NetManager.prototype.onError = function (net) {
        if (net.callback) {
            net.callback(false);
        }
        if (!net.hideMsg) {
            GDispatcher_1.GDispatcher.dispatchEvent(ABNetManager_1.ABNetManager.ERROR, net);
            onNotSuccess_1.onNotSuccess();
        }
    };
    // tslint:disable-next-line:max-file-line-count
    //////////////////////////////////////// projectX ////////////////////////////////////////
    /**
     * 获取域名
     * @param callback
     */
    NetManager.prototype.getDomain = function (callback) {
        var net = {
            name: NetName_1.NetName.GET_DOMAIN,
            uri: '/projectx/getDomain.query',
            type: 'get',
            dataType: 'json',
            param: {},
            callback: callback
        };
        this.send(net);
    };
    /**
     * 查询发奖规则的奖项
     * @param callback
     * @param strategyId 发奖规则id
     * @param optionId 奖项id，不传查询所有奖品
     */
    NetManager.prototype.queryPrizeList = function (callback, strategyId, optionId) {
        var net = {
            name: NetName_1.NetName.QUERY_PRIZE_LIST,
            uri: '/projectx/{projectId}/' + strategyId + '.query',
            type: 'get',
            dataType: 'json',
            param: optionId ? {
                optionId: optionId
            } : {},
            callback: callback
        };
        this.send(net);
    };
    /**
     * 预扣积分
     * @param callback
     * @param toPlaywayId
     * @param toActionId
     * @param desc
     * @param credits
     */
    NetManager.prototype.creditsCost = function (callback, toPlaywayId, toActionId, desc, credits) {
        var net = {
            name: NetName_1.NetName.CREDITS_COST,
            uri: '/projectx/{projectId}/credits/creditsCost.do',
            type: 'post',
            dataType: 'json',
            param: {
                toPlaywayId: toPlaywayId,
                toActionId: toActionId,
                desc: desc,
                credits: credits,
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 查询扣积分状态
     * @param callback
     * @param ticketNum
     * @param pollingCheck
     * @param pollingCount
     */
    NetManager.prototype.queryStatus = function (callback, ticketNum, pollingCheck, pollingCount) {
        if (pollingCount === void 0) { pollingCount = 10; }
        var net = {
            name: NetName_1.NetName.QUERY_STATUS,
            uri: '/projectx/{projectId}/credits/queryStatus.do',
            type: 'get',
            dataType: 'json',
            param: {
                ticketNum: ticketNum,
            },
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount,
        };
        this.send(net);
    };
    /**
     * 查询奖品信息
     * @param callback
     * @param ids
     */
    NetManager.prototype.queryPrizeInfo = function (callback, ids) {
        var net = {
            name: NetName_1.NetName.QUERY_PRIZE_INFO,
            uri: '/projectx/{projectId}/prize.query',
            type: 'get',
            dataType: 'json',
            param: {
                ids: ids,
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 查询用户拥有的道具
     */
    NetManager.prototype.queryUserSpList = function (callback) {
        var net = {
            name: NetName_1.NetName.QUERY_PRIZE_INFO,
            uri: '/projectx/{projectId}/getUserSpList.query',
            type: 'get',
            dataType: 'json',
            param: {},
            callback: callback
        };
        this.send(net);
    };
    /**
     * 查询优惠卷信息
     * @param callback
     * @param projectOrderNo
     * @param pollingCheck
     * @param pollingCount
     */
    NetManager.prototype.getCouponInfo = function (callback, projectOrderNo, pollingCheck, pollingCount) {
        if (pollingCount === void 0) { pollingCount = 10; }
        var net = {
            name: NetName_1.NetName.GET_COUPON_INFO,
            uri: '/aaw/projectx/getCouponInfo',
            type: 'get',
            dataType: 'json',
            param: {
                projectOrderNo: projectOrderNo,
            },
            callback: callback,
            pollingCount: pollingCount,
            pollingCheck: pollingCheck
        };
        this.send(net);
    };
    /**
     * 查询我的奖品列表
     * @param callback - 回调函数
     * @param credits - 是否包含加积分，传参数代表包含加积分
     */
    NetManager.prototype.queryRecords = function (callback, credits) {
        var param = {};
        credits ? credits['credits'] = credits : 0;
        var net = {
            name: NetName_1.NetName.QUERY_RECORDS,
            uri: '/projectx/{projectId}/records.query',
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback
        };
        this.send(net);
    };
    /**
     * 获得用户信息
     * @param callback
     */
    NetManager.prototype.getProjectUserInfo = function (callback) {
        var net = {
            name: NetName_1.NetName.GET_PROJECTUSERINFO,
            uri: '/ctool/getProjectUserInfo',
            type: 'get',
            dataType: 'json',
            param: {},
            callback: callback
        };
        this.send(net);
    };
    /**
     * 获得规则
     * @param callback
     */
    NetManager.prototype.getRule = function (callback) {
        var net = {
            name: NetName_1.NetName.GET_RULE,
            uri: '/projectx/{projectId}/projectRule.query',
            type: 'get',
            dataType: 'json',
            param: {},
            callback: callback
        };
        this.send(net);
    };
    /**
     * // 聚合查询
     * querys = {
     *     key:{    key唯一 返回值会设置到key中	是	[object]
     *         path:    原先接口的路径	是	[string]
     *         params:  原先接口的参数	是	[string]
     *     }
     * }
     */
    NetManager.prototype.mergeQuery = function (callback, querys) {
        var net = {
            name: NetName_1.NetName.MERGE_QUERY,
            uri: '/projectx/{projectId}/merge.query',
            type: 'post',
            dataType: 'json',
            param: {
                querys: JSON.stringify(querys)
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 查询发奖规则的中奖记录
     * @param {Function} callback
     * @param strategyId 发奖规则
     * @param limit 条数
     * @param credits 传则包含积分奖品，不传则不包含
     */
    NetManager.prototype.strategyRecords = function (callback, strategyId, limit, credits) {
        var param = {
            strategyId: strategyId,
            limit: limit
        };
        credits ? (param['credits'] = credits) : 0;
        var net = {
            name: NetName_1.NetName.STRATEGY_RECORDS,
            uri: '/projectx/{projectId}/strategyRecords.query',
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback
        };
        this.send(net);
    };
    ///////////////////////////////////////////////////////////////////
    //// 工行欢趣庄园
    /**
     * 获取地块信息
     * @param callback
     */
    NetManager.prototype.getLandInfo = function (callback) {
        var net = {
            name: NetName_1.NetName.GET_LANDINFO,
            uri: '/projectx/{projectId}/join_1/landInfo.do',
            type: 'get',
            dataType: 'json',
            param: {},
            callback: callback
        };
        this.send(net);
    };
    /**
     * 种植
     * @param callback
     * @param landId 地块Id
     * @param petId 植物Id
     */
    NetManager.prototype.doPlant = function (callback, landId, petId) {
        var net = {
            name: NetName_1.NetName.DO_PLANT,
            uri: '/projectx/{projectId}/join_1/join.do',
            type: 'post',
            dataType: 'json',
            param: {
                landId: landId,
                petId: petId
            },
            callback: callback
        };
        this.send(net);
    };
    NetManager.prototype.doFeed = function (callback, landId) {
        var net = {
            name: NetName_1.NetName.DO_FEED,
            uri: '/projectx/{projectId}/join_2/join.do',
            type: 'post',
            dataType: 'json',
            hideMsg: true,
            param: {
                landId: landId,
            },
            callback: callback
        };
        this.send(net);
    };
    NetManager.prototype.priceInfo = function (callback) {
        var net = {
            name: NetName_1.NetName.DO_FEED,
            uri: '/projectx/{projectId}/join_4/priceInfo.do',
            type: 'get',
            dataType: 'json',
            hideMsg: true,
            param: {},
            callback: callback
        };
        this.send(net);
    };
    NetManager.prototype.doHarvest = function (callback, landId) {
        var net = {
            name: NetName_1.NetName.DO_HARVEST,
            uri: '/projectx/{projectId}/join_3/join.do',
            type: 'post',
            dataType: 'json',
            param: {
                landId: landId,
            },
            callback: callback
        };
        this.send(net);
    };
    NetManager.prototype.doSell = function (callback, spId, count) {
        var net = {
            name: NetName_1.NetName.DO_SELL,
            uri: '/projectx/{projectId}/join_4/join.do',
            type: 'post',
            dataType: 'json',
            param: {
                spId: spId,
                count: count
            },
            callback: callback
        };
        this.send(net);
    };
    NetManager.prototype.getSellInfo = function (callback) {
        var net = {
            name: NetName_1.NetName.GET_SELLINFO,
            uri: '/projectx/{projectId}/join_4/saleInfo.do',
            type: 'get',
            dataType: 'json',
            param: {},
            callback: callback
        };
        this.send(net);
    };
    NetManager.prototype.getConsumerInfo = function (callback) {
        var net = {
            name: NetName_1.NetName.Get_CONSUMERINFO,
            uri: '/projectx/{projectId}/join_1/consumerInfo.do',
            type: 'get',
            dataType: 'json',
            param: {},
            callback: callback
        };
        this.send(net);
    };
    NetManager.prototype.doTask = function (callback, taskId) {
        var net = {
            name: NetName_1.NetName.DO_TASK,
            uri: '/projectx/{projectId}/join_5/join.do',
            type: 'post',
            dataType: 'json',
            param: {
                taskId: taskId,
            },
            callback: callback
        };
        this.send(net);
    };
    NetManager.prototype.getTaskInfo = function (callback) {
        var net = {
            name: NetName_1.NetName.GET_TASKINFO,
            uri: '/projectx/{projectId}/join_5/taskInfo.do',
            type: 'post',
            dataType: 'json',
            param: {},
            callback: callback
        };
        this.send(net);
    };
    NetManager.prototype.prizeExchange = function (callback, strategyId) {
        var net = {
            name: NetName_1.NetName.PRIZE_EXCHANGE,
            uri: '/projectx/{projectId}/join_6/join.do',
            type: 'post',
            dataType: 'json',
            hideMsg: true,
            param: {
                strategyId: strategyId
            },
            callback: callback
        };
        this.send(net);
    };
    NetManager.prototype.prizeInfo = function (callback, prizeIds) {
        var net = {
            name: NetName_1.NetName.GET_PRIZEINFO,
            uri: '/projectx/{projectId}/join_6/prizeInfo.do',
            type: 'get',
            dataType: 'json',
            param: {
                prizeIds: prizeIds
            },
            callback: callback
        };
        this.send(net);
    };
    NetManager.prototype.propExchange = function (callback, spId, ticket) {
        var net = {
            name: NetName_1.NetName.PROP_EXCHANGE,
            uri: '/projectx/{projectId}/join_7/join.do',
            type: 'post',
            dataType: 'json',
            hideMsg: true,
            param: {
                spId: spId,
                ticket: ticket
            },
            callback: callback
        };
        this.send(net);
    };
    NetManager.prototype.propInfo = function (callback) {
        var net = {
            name: NetName_1.NetName.PROPINFO,
            uri: '/projectx/{projectId}/join_7/propInfo.do',
            type: 'get',
            dataType: 'json',
            param: {},
            callback: callback
        };
        this.send(net);
    };
    NetManager.prototype.useProp = function (callback, spId, landId) {
        var net = {
            name: NetName_1.NetName.USER_PROP,
            uri: '/projectx/{projectId}/join_8/join.do',
            type: 'post',
            dataType: 'json',
            param: {
                spId: spId,
                landId: landId
            },
            callback: callback
        };
        this.send(net);
    };
    return NetManager;
}(ABNetManager_1.ABNetManager));
exports.NetManager = NetManager;
__reflect(NetManager.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/libs/tw/manager/NetManager\".NetManager");
// window['nt'] = NetManager.ins;
var regular = "(\\S+)//(\\S+)/(\\S+)/(\\S+)/(\\S+)";
var re = new RegExp(regular, "g");
window['projectId'] = window.location.href.replace(re, "$4");
console.log(window['projectId']);
//# sourceMappingURL=NetManager.js.map