// tslint:disable:prefer-const
// tslint:disable:no-var-keyword

import { Vector } from "./Vector";
import { Projection } from "./Projection";
export class Ball {
    type;
    collideNormal;
    isCollide;
    /** 
     * 1：射出阶段（应用碰撞检测，不应用重力,可根据加速，碰壁或bloc变为2，碰底后变为3）。
     * 2：碰撞阶段（应用重力和检测，可根据加速）。
     * 3：回收阶段（不应用重力，不应用检测，以最快速度回到初始位置） */
    collideStatus = 1;
    recoverDirection;    //false为左，true为右

    recoverMark = false;
    radius;
    view;
    velocity = new Vector();
    constructor(radius, view) {
        this.radius = radius;
        this.view = view;
    }

    //圆形在投影轴上的投影对象
    project(axis) {
        var scalars = []; //用于存放在投影轴上的投影
        var dotProduct = new Vector(this.view.x, this.view.y).dotProduct(axis); //得到圆心向量在投影轴上的投影

        // scalars.push(dotProduct);
        scalars.push(dotProduct + this.radius);
        scalars.push(dotProduct - this.radius);

        //得到圆投影对象的最大值与最小值
        // return new Projection(Math.min.apply(Math, scalars), Math.max.apply(Math, scalars));
        return new Projection(dotProduct - this.radius, dotProduct + this.radius)
    };
}