import { GameModel } from '../common/GameModel';
import { DataManager } from './../../manager/DataManager';
import { TwLang } from '../../util/TwLang';
import { GFun } from '../../../tc/util/GFun';
import { IUserData } from '../../data/game/common/IUserData';
// import { IUserData } from '../../data/game/common/IUserData';
export class GameRealTimeRankModel extends GameModel {
    /**
     * 我得排行文案
     * @param inRankStr 
     * @param unitName 单位
     * @param outRankStr 
     */
    public getRankTxt(inRankStr: string = TwLang.lang_015, unitName: string = TwLang.lang_016, outRankStr: string = TwLang.lang_014): string {
        let str: string;
        if (DataManager.ins.realTimeRankData.myUserData && DataManager.ins.realTimeRankData.myUserData.rank) {
            str = GFun.replace(inRankStr, 
                [DataManager.ins.realTimeRankData.myUserData.maxScore, unitName, DataManager.ins.realTimeRankData.myUserData.rank]);
        } else {
            str = outRankStr;
        }
        return str;
    }

    /**
     * 用户列表
     */
    public get userList(): IUserData[] {
        return DataManager.ins.realTimeRankData.userList;
    }
}