import { wall, wallMask, basket, basketMask } from "./collisionConfig";
import StartScene from "./StartScene";

const createBox = (_this: StartScene) => {
    const path1 = Matter.Vertices.fromPath('385 168 640 201 695 528 644 866 392 907 109 868 57 546 118 206 0 206 0 1624 750 1624 750 0', null);
    const body = Matter.Bodies.fromVertices(430, 717, [path1], { isStatic: true, collisionFilter: { group: wall, category: wall, mask: wallMask } }, true);
    Matter.World.add(_this._engine.world, body);

    const path2 = Matter.Vertices.fromPath('118 206 385 168 385 100', null);
    const body2 = Matter.Bodies.fromVertices(425 - 10 - 100 - 10 - 10 + 1, 30 + 100 + 10 + 10 + 6, [path2], { isStatic: true, collisionFilter: { group: wall, category: wall, mask: wallMask } }, true);
    Matter.World.add(_this._engine.world, body2);

    const basketpath1 = Matter.Vertices.fromPath('290 432 324 476 326 476 292 432 ', null);
    const basketbody1 = Matter.Bodies.fromVertices(311, 452, [basketpath1], { isStatic: true, collisionFilter: { group: basket, category: basket, mask: basketMask } }, true);
    Matter.World.add(_this._engine.world, basketbody1);

    const basketpath2 = Matter.Vertices.fromPath('471 435 443 481 441 481 469 435', null);
    const basketbody2 = Matter.Bodies.fromVertices(449, 452, [basketpath2], { isStatic: true, collisionFilter: { group: basket, category: basket, mask: basketMask } }, true);
    Matter.World.add(_this._engine.world, basketbody2);

    //153 823
    const w = 100;
    const h = 50;
    const rect = _this._egretRender.rectangle(153 + w / 2, 833 + h / 2, w, h, null, { isStatic: true, collisionFilter: { group: wall, category: wall, mask: wallMask } });
    const rect2 = _this._egretRender.rectangle(553 - 10 - 30 - 5 + w / 2, 833 + h / 2, w, h, null, { isStatic: true, collisionFilter: { group: wall, category: wall, mask: wallMask } });
}

export default createBox