import MainBase from "../libs/tl/MainBase";
import Msg from "./alert/Msg";
import PanelCtrl from "./ctrls/panelCtrl";
import SceneCtrl from "./ctrls/sceneCtrl";
import RulePanel from "./rulePanel/RulePanel";
import { ModuleTypes } from "./types/sceneTypes";
import StartScene from "./startScene/StartScene";

class Main extends MainBase {
    protected registerModules() {
        PanelCtrl.instance.registerPanelClass(ModuleTypes.MSG_PANEL, Msg);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.RULE_PANEL, RulePanel);
        SceneCtrl.instance.registerSceneClass(ModuleTypes.START_SCENE, StartScene);
    }

    protected async createGameScene() {
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
    }
}

window['Main'] = Main;