export default class BoxOpenState extends egret.Bitmap {
    _type: string;
    onReady: () => void;
    constructor(type) {
        super();
        this._type = type;
    }

    start(): any {
        RES.getResByUrl(__boxOpenState__, (sheet: egret.SpriteSheet) => {
            const texture = sheet.getTexture(`${this._type}OpenState`);
            this.$setBitmapData(texture);
            this.anchorOffsetX = texture.textureWidth >> 1;
            this.anchorOffsetY = texture.textureHeight >> 1;
            this.scaleX = this.scaleY = 1.5;
            egret.Tween.get(this)
                .set({ alpha: 0 })
                .to({ alpha: 1 }, 200)
                .call(() => {
                    this.onReady();
                    this.shake();
                })
        }, this, RES.ResourceItem.TYPE_SHEET);
    }

    destroy() {
        egret.Tween.removeTweens(this);
        egret.Tween.get(this).to({alpha:0},500).call(()=>{
            this.parent.removeChild(this);
        });
    }
    shake(): any {
        const x0 = this.x;
        const y0 = this.y;
        const offset = 10;

        egret.Tween.get(this, { loop: true })
            .set({ y: y0 - offset, x: x0 }).wait(30)
            .set({ y: y0, x: x0 + offset }).wait(30)
            .set({ y: y0 + offset, x: x0 }).wait(30)
            .set({ y: y0, x: x0 - offset }).wait(30)
            .set({ y: y0 - offset, x: x0 }).wait(30)
            .set({ y: y0, x: x0 + offset }).wait(30)
            .set({ y: y0 + offset, x: x0 }).wait(30)
            .set({ y: y0, x: x0 - offset }).wait(30)
            .wait(500);
    }
}