import { award, awardMask } from "./collisionConfig";
import createItem from "./items/createItem";
import StartScene from "./StartScene";
import LabelType from "./LabelType";

export default (_this: StartScene) => {
    const startY = 984;
    const startX = 100;
    setInterval(() => {
        // const funcs = [createBoom, createIceCream, createDonut, createCandy2, createGift2, createGift3, createEgg];
        // const types = [LabelType.Egg];
        const types = [LabelType.Boom,LabelType.IceCream,LabelType.Donut,LabelType.Candy2,LabelType.Gift2,LabelType.Gift3,LabelType.Egg];
        const i = Math.floor(Math.random() * types.length);

        const type = types[i];
        if (type == LabelType.Candy2) {
            const forceScale = 15;
            const leftStart = { x: startX, y: startY, forceX: 0.01 * forceScale };
            const rightStart = { x: 750 - startX, y: startY, forceX: -0.01 * forceScale };
            const start = Math.random() > 0.5 ? leftStart : rightStart;
            const scale = 2;
            const baseItem = createItem(scale, type);
            _this._egretRender.rectangle(start.x, start.y, 49 * scale, 18 * scale, baseItem,
                {
                    isStatic: false,
                    force: { x: start.forceX, y: 0 },
                    friction: 0,
                    restitution: 0.7,
                    collisionFilter: { group: award, category: award, mask: awardMask }
                }
            );
        } else {
            const forceScale = 7;
            const leftStart = { x: startX, y: startY, forceX: 0.01 * forceScale };
            const rightStart = { x: 750 - startX, y: startY, forceX: -0.01 * forceScale };
            const start = Math.random() > 0.5 ? leftStart : rightStart;
            const size = 49 * 1.15;
            const maxsize = 49;
            const baseItem = createItem(size / maxsize, type);
            _this._egretRender.circle(start.x, start.y, size / 2, baseItem,
                {
                    isStatic: false,
                    force: { x: start.forceX, y: 0 },
                    friction: 0,
                    restitution: .7,
                    collisionFilter: { group: award, category: award, mask: awardMask }
                }
            );
        }
    }, 1000);
}