import StartSceneBase from "../../libs/new_wx/components/StartSceneBase";
import EgretRender from "../physics/EgretRender";
import getAngle from "../physics/utils/getAngle";
import getRotation from "../physics/utils/getRotation";
import check from "./check";
import createBox from "./createBox";
import createItems from "./createItems";
import wait from "../../libs/new_tc/wait";

export default class StartScene extends StartSceneBase {
    _engine: Matter.Engine;
    _egretRender: EgretRender;
    // _debugRender:DebugRender;
    private _lastTimestamp = 0;
    _startStandbyBubblesLeft: number;
    _startStandbyBubblesRight: number;
    egretRenderContainer: egret.Sprite;
    async start(data?) {
        super.start();
        egret.lifecycle.onPause = () => {
            console.log("app 进入后台");
            egret.ticker.pause(); // 关闭渲染与心跳
        }
        egret.lifecycle.onResume = () => {
            console.log("app 进入前台");
            this._lastTimestamp = 0;
            egret.ticker.resume(); // 打开渲染与心跳
        }

        //创建引擎
        const engine = Matter.Engine.create();
        this._engine = engine;

        //创建egret渲染
        this.egretRenderContainer = new egret.Sprite();
        this._egretRender = new EgretRender(this.egretRenderContainer, this._engine);
        this.once(egret.Event.ADDED_TO_STAGE, () => { this['group'].y = this.stage.stageHeight - 1624; }, this);
        this['group'].addChildAt(this.egretRenderContainer, 3);
        // [this['basket_bottom'], this['basket_top'], this['glass']].forEach(item =>
        //     egret.Tween.get(item).set({ alpha: 0 }).to({ alpha: 1 }, 500));

        // run the engine
        this.runEngine();

        const options: any = {
            width: 750,
            height: 1624,
            wireframes: !1,
        };

        const render = Matter.Render.create({
            element: document.getElementById('debugCanvas'),
            engine: engine,
            options: options
        });
        Matter.Render.run(render);

        // this._debugRender=new DebugRender(this._engine);
        // this['group'].addChild(this._debugRender);

        this.initJoker(this['joker']);
        this.initLights(this['lights1'], this['lights2']);
        this.runGame();
    }

    async initLights(img1: eui.Image, img2: eui.Image) {
        img1.alpha = 0;
        img2.alpha = 1;
        const freq = 500;
        egret.Tween.get(img1, { loop: true })
            .set({ alpha: 1 }).wait(freq)
            .set({ alpha: 0 }).wait(freq);
        egret.Tween.get(img2, { loop: true })
            .set({ alpha: 0 }).wait(freq)
            .set({ alpha: 1 }).wait(freq);
    }

    async initJoker(joker: eui.Image) {
        egret.Tween.get(joker)
            .to({ rotation: -40 }, 1500, egret.Ease.quadInOut);
        await wait(1500);
        egret.Tween.get(joker, { loop: true })
            .to({ rotation: 40 }, 3000, egret.Ease.quadInOut)
            .to({ rotation: -40 }, 3000, egret.Ease.quadInOut);
    }

    _seesaw: Matter.Body;
    async runGame() {
        const { seesaw } = createBox(this);
        this._seesaw = seesaw;

        const reslist = ['boom', 'gift', 'gift2', 'gift3', 'candy', 'candy2',
            'coin',
            'donut',
            'egg',
            'icecream']
        await Promise.all(
            reslist.map(res => RES.getResAsync(`${res}_json`))
        );

        createItems(this);

        let touchLeft = false;
        let touchRight = false;
        let angle = 0;
        const ontick = () => {
            const rotationLimit = 30;
            if (touchLeft)
                angle += getAngle(-1);
            if (touchRight)
                angle += getAngle(1);
            let rotation = getRotation(angle);
            if (rotation > rotationLimit) {
                rotation = rotationLimit;
                angle = getAngle(rotationLimit);
            }
            if (rotation < -rotationLimit) {
                rotation = -rotationLimit;
                angle = getAngle(-rotationLimit);
            }
            Matter.Body.setAngle(seesaw, getAngle(rotation));
            return false;
        }

        this.stage.addEventListener(egret.TouchEvent.TOUCH_BEGIN, (e: egret.TouchEvent) => {
            touchLeft = e.stageX < 375;
            touchRight = !touchLeft;
            ontick();
            egret.startTick(ontick, this);
        }, this);

        this.stage.addEventListener(egret.TouchEvent.TOUCH_END, (e: egret.TouchEvent) => {
            egret.stopTick(ontick, this);
        }, this);

        [this['leftBtn'], this['rightBtn']].forEach(btn => {
            btn.addEventListener(egret.TouchEvent.TOUCH_TAP, (e: egret.TouchEvent) => {

            }, this);
        });
    }

    runEngine() {
        egret.startTick(this.onTick, this);
    }

    private onTick(timestamp: number) {
        if (this._lastTimestamp === 0) {
            this._lastTimestamp = timestamp;
            return;
        }
        let delta = timestamp - this._lastTimestamp;
        if (delta > 20)
            delta = 20;
        this._lastTimestamp = timestamp;
        Matter.Engine.update(this._engine, delta);
        this._egretRender.run();
        // this._debugRender.run();
        check(this);
        return false;
    }

    destroy() {
        super.destroy();
    }

}