import {getSkinPath, getSvga} from "../../../utils";
import Crop from "./Crop";
import {NetManager} from "../../../../libs/tw/manager/NetManager";
import {getlogDpm} from "../../../comm/getlogItem";
import {M_HideOption, M_ShowOption} from "./OptionPanel";
import {detectionDiamond, petData} from "../Const";
import TouchEvent = egret.TouchEvent;
import PanelCtrl from "../../../ctrls/panelCtrl";
import UnlockPanel from "../../../Panels/UnlockPanel";
import Image = eui.Image;
import {loadSvga} from "../../../comm/loadSvga";
import Event = egret.Event;
import {waitAsync} from "../../../comm/UtilsConst";
import {M_UpdateLand} from "../LandMgr";

enum LAND_STATE {
    NONE = 'none',   // 无
    ACTIVE = 'active', // 点击
    PLANT = 'plant',  // 植物
    ANIMAL = 'animal',  // 动物
    LOCK = 'lock'  // 锁住
}

/**
 * 土地类
 */
export default class Land extends eui.Component {
    public land: Image;
    public fence: Image;
    public trough: Image;

    private data = null;

    public index;

    public state: LAND_STATE;
    private crop: Crop;

    constructor(data?) {
        super();
        this.skinName = getSkinPath('Objs/Land');
        this.data = data || null;
        this.index = data.index;

        this.x = data.x;
        this.y = data.y;

        this.initEvents();  // 注册事件
        this.changeState(LAND_STATE.NONE);
        this.initUI();  // 设置显示
    }

    /**
     * 取消active状态
     */
    public reActive() {
        this.state == LAND_STATE.ACTIVE && this.changeState(LAND_STATE.NONE);
    }

    public plant(data) {
        this.crop.plant(data);
    }

    /**
     * 更新数据
     * @param data
     */
    public updateData(data) {
        this.data = data;
        this.changeState(LAND_STATE.NONE);
        const landData = this.data.data;

        // 根据数据添加Crop 初始化状态
        if (landData.lock) {    // 锁住的
            this.changeState(LAND_STATE.LOCK);
        } else if (landData.petId) {    // 有种的
            this.changeState(petData[landData.petId].type); // 是动物显示栅栏和食槽
        } else {    // 啥也没有，但是解锁的
            this.changeState(LAND_STATE.NONE);
        }
        // 刷新一下上面的作物
        this.crop && this.crop.updateDate(this.data);
    }

    public destroy() {
        this.land.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
        this.crop && this.crop.destroy();
        this.crop = null;
    }

    /**
     * 设置点击参数
     */
    private setTouchOption() {
        this.touchEnabled = false;  // 保证空白处不可点击，且子对象可点击
        this.touchChildren = true;
        this.land.touchEnabled = true;
        // this.land.pixelHitTest = true;  // 保证透明像素不可点击 TODO ios14像素点击不能用
        this.fence.touchEnabled = false;    // 保证栅栏和食槽不可点击
        this.trough.touchEnabled = false;
    }

    private initEvents() {
        this.land.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    }

    private onTap(e) {

        /* TODO ios14像素点击不能用 手动检测菱形包围盒 */
        if (!detectionDiamond(e.localX, e.localY, this.width, this.height)) {
            M_HideOption();
            return;
        }
        /* TODO ios14像素点击不能用 手动检测菱形包围盒 */

        console.log(`%c点击了第${this.index}块土地, 当前状态是${this.state}`, 'color:green');

        switch (this.state) {
            case LAND_STATE.LOCK:   // 锁住的
                M_HideOption();
                PanelCtrl.instance.show(UnlockPanel, {
                    landId: this.index,
                    call: this.unlock
                });
                break;

            case LAND_STATE.NONE:   // 没有
                // 显示Option
                NetManager.ins.clickLog(getlogDpm(8, this.index));
                M_ShowOption({index: this.index});
                this.changeState(LAND_STATE.ACTIVE);
                break;


            case LAND_STATE.ANIMAL: // 动物
            case LAND_STATE.PLANT:  // 植物
                const event = new TouchEvent(TouchEvent.TOUCH_TAP);
                event.$setTarget(this.crop);
                this.crop.dispatchEvent(e);
                break;

            case LAND_STATE.ACTIVE: // 点击激活的 肯定没有这种情况
                break;
        }
    }

    /**
     * 解锁土地
     */
    private unlock = async () => {
        await waitAsync(500);
        const unlockEffect = await loadSvga(getSvga('unlock_land'));
        unlockEffect.y = -65;
        unlockEffect.addEventListener(Event.COMPLETE, () => {
            unlockEffect.stop();
            this.removeChild(unlockEffect);

            M_UpdateLand(this.index);   // 在动画结束的时候刷新

        }, this);
        this.addChild(unlockEffect);
    }

    private initUI() {
        if (!this.data.data.lock) {
            NetManager.ins.showLog(getlogDpm(8, this.index));
        }
        this.setTouchOption();  // 设置点击参数

        // 根据数据添加Crop 初始化状态
        this.updateData(this.data);
        this.crop = new Crop(this.data);
        this.addChildAt(this.crop, 2);
        // this.rotation = 10;
    }

    // 改变状态积
    private changeState(state: LAND_STATE) {
        if (state == this.state) {
            return;
        }

        this.state = state; // 设置状态

        this.land.source = `plant_land_${this.state}_png`;  // 设置图片
        this.fence.visible = (this.state == LAND_STATE.ANIMAL); // 显示栅栏
        this.trough.visible = (this.state == LAND_STATE.ANIMAL);    // 显示食槽

        /// TODO 定义状态积详情
        switch (this.state) {
            case LAND_STATE.NONE:   // 啥也没有

                break;
            case LAND_STATE.ACTIVE: // 点击

                break;
            case LAND_STATE.PLANT:  // 植物

                break;
            case LAND_STATE.ANIMAL: // 动物

                break;

            case LAND_STATE.LOCK: // 动物

                break;
            default:
                break;
        }
    }
}
