import Panel from "../views/Panel";
import { MainDispatcher, MainIns } from "../Scenes/MainScene/MainScene";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";

export default class SelledPanel extends Panel {
    public closeBtn: eui.Image;
    public infoLabel: eui.Label;
    public numLabel: eui.Label;
    public okBtn: eui.Image;

    public get skinKey() {
        return 'SelledPanel'
    }

    public get groupName() {
        return 'selled_panel'
    }

    constructor(data?) {
        super(data);
    }

    onShowAnim() {
        // const canvasH = 750 / window.innerWidth * window.innerHeight;
        egret.Tween.get(this).set({ alpha: 0 }).to({ alpha: 1 }, 233, egret.Ease.quadInOut);
    }

    protected start() {
        super.start();

        this.initUI();
        this.okBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchClose, this);
        if (MainDispatcher)
            MainDispatcher.dispatchEvent('updateWareHouse');
        GDispatcher.dispatchEvent('updateExchangePanel');
    }

    onTouchClose(): any {
        // MainDispatcher.dispatchEvent('closeWareHouse');
        if (MainIns())
            MainIns().mainUI.addGold(); // 收豆子的动画
        super.onTouchClose();
    }

    private initUI(): void {
        this.y = 750 / window.innerWidth * window.innerHeight * 0.2;

        this.infoLabel.text = `您的${this.data.name}已被欢趣商店收下`;
        this.numLabel.text = `为您献上${this.data.total}个欢趣豆`;

    }

    destroy() {
        super.destroy();
        this.okBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchClose, this);
    }

}
