import Panel from "../views/Panel";
import TouchEvent = egret.TouchEvent;
import {petData} from "../Scenes/MainScene/Const";
import {M_ShowOption} from "../Scenes/MainScene/Objs/OptionPanel";
import Tween = egret.Tween;

export default class IntroducePanel extends Panel {
    public closeBtn: eui.Button;
    public btn: eui.Button;
    public img: eui.Image;
    public txt: eui.Label;

    public get skinKey() {
        return 'IntroducePanel'
    }

    protected hideAnim(): egret.Tween {
        return Tween.get(this);
    }

    public get groupName() {
        return 'introduce_panel'
    }

    constructor(data?) {
        super(data);

    }

    public initEvents() {
        super.initEvents();
        this.btn.addEventListener(TouchEvent.TOUCH_TAP, this.tapBtn, this);
    }

    public removeEvents() {
        super.removeEvents();
        this.btn.removeEventListener(TouchEvent.TOUCH_TAP, this.tapBtn, this);
    }

    private tapBtn() {
        this.data.call && this.data.call();
        super.hidePanel();
    }

    public hidePanel() {
        super.hidePanel();
        M_ShowOption({index: this.data.landId});
    }

    protected start() {
        super.start();
        this.initUI();
    }

    private initUI(): void {
        console.log("当前的介绍图片---》》",this.data,petData[this.data.petId])
        this.img.source = `introduce_${petData[this.data.petId || 0].key}_png`;
        this.txt.text = petData[this.data.petId || 0].introduce;
    }
}
