"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var GDispatcher_1 = require("../../libs/tc/util/GDispatcher");
//设置隐藏属性和改变可见属性的事件的名称
var hidden, visibilityChange;
switch (true) {
    default:
    case (typeof document.hidden !== 'undefined'):
        hidden = 'hidden';
        visibilityChange = 'visibilitychange';
        break;
    case (typeof document['msHidden'] !== 'undefined'):
        hidden = 'msHidden';
        visibilityChange = 'msvisibilitychange';
        break;
    case (typeof document['webkitHidden'] !== 'undefined'):
        hidden = 'webkitHidden';
        visibilityChange = 'webkitvisibilitychange';
        break;
}
var handleVisibilityChange = function (e) {
    if (document.visibilityState == "visible") {
        GDispatcher_1.GDispatcher.dispatchEvent('docVisible');
        console.log('document visible');
    }
    if (document.visibilityState == "hidden") {
        GDispatcher_1.GDispatcher.dispatchEvent('docHide');
        console.log('document hidden');
    }
};
exports.docEvent = function () {
    document.addEventListener(visibilityChange, handleVisibilityChange, false);
    // 页面重载
    document.body['onbeforeunload'] = function () {
        GDispatcher_1.GDispatcher.dispatchEvent('onbeforeunload');
        console.log('document onbeforeunload');
    };
};
//# sourceMappingURL=DocumentEvent.js.map