import hdGameDoDojoin from "../../libs/new_tw/ctrls/hdGameDoDojoin";
import Loading from "../../libs/new_wx/components/Loading";
import Scene from "../../libs/new_wx/components/Scene";
import PanelCtrl from "../../libs/new_wx/ctrls/panelCtrl";
import SceneCtrl from "../../libs/new_wx/ctrls/sceneCtrl";
import { ModuleTypes } from "../../libs/new_wx/types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";

export default class StartScene extends Scene {
    ruleBtn: eui.Button;
    htmlRuleBtn: eui.Button;
    optionBtn: eui.Button;
    recordBtn: eui.Button;
    startBtn: eui.Button;
    rankBtn: eui.Button;
    countdownTxt: eui.Label;
    elements: eui.Group;

    countTxt: eui.Label;
    exemptionTxt: eui.Label;

    async start(data?) {
        this.updateCountTxt();
        super.start();

        egret.Tween.get(this.startBtn, { loop: true }).to({ scaleX: .9, scaleY: .9 }, 150).to({ scaleX: 1, scaleY: 1 }, 500, egret.Ease.getBackOut(5)).wait(600);

        NetManager.ins.getCredits(() => {
            this.data.credit = `我的${DataManager.ins.getCreditsData.unitName}:${DataManager.ins.getCreditsData.consumerCredits}`;
        });

        NetManager.ins.getPrizeInfo(() => { }, window['revivePlugId']);

        for (let i = 1; i <= 5; i++) {
            const ele = this['ele' + i];
            egret.Tween.get(ele, { loop: true }).set({ rotation: 0 }).to({ rotation: Math.random() > 0.5 ? 360 : -360 }, 3000)
        }
    }

    updateCountTxt() {
        let countTxt = '';

        const { element } = DataManager.ins.ajaxElementData;
        if (element.freeLimit > 0) {
            if (element.status == 5)
                countTxt = `今日剩余免费次数:${element.freeLimit}次`
            if (element.status == 7)
                countTxt = `剩余免费次数:${element.freeLimit}次`
        } else {
            countTxt = `${element.needCredits}${CFG.unitName}/次`
        }

        this.data.count = `${countTxt}`;
    }

    initEvents() {
        if (this.ruleBtn)
            this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        if (this.htmlRuleBtn)
            this.htmlRuleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_htmlRuleBtn, this);
        if (this.optionBtn)
            this.optionBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_optionBtn, this);
        if (this.recordBtn)
            this.recordBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_recordBtn, this);
        if (this.startBtn)
            this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this);
        if (this.rankBtn)
            this.rankBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_rankBtn, this);
    }

    onTap_ruleBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
    }

    onTap_htmlRuleBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.HTML_RULE_PANEL);
    }

    onTap_optionBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.OPTIONS_PANEL);
    }

    onTap_recordBtn(e: egret.Event) {
    }

    async onTap_startBtn(e?: egret.Event) {
        this.startBtn.touchEnabled = false;
        Loading.instace.show();
        hdGameDoDojoin((success) => {
            Loading.instace.hide();
            this.startBtn.touchEnabled = true;
            if (success)
                SceneCtrl.instance.change(ModuleTypes.PLAY_SCENE);
        });
    }

    onTap_rankBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.RANK_PANEL);
    }

    get skinKey() { return 'Start' }
}