import Panel from "../../libs/new_wx/components/Panel";
import { DataManager } from "../../libs/tw/manager/DataManager";
import relive from "../playScene/relive";
import PanelCtrl from "../../libs/new_wx/ctrls/panelCtrl";

export default class RelivePanel extends Panel {
    start() {
        super.start();
        const num = window['revivePlugId'];
        const unitName = DataManager.ins.getCreditsData.unitName || '积分';
        const costCredits = DataManager.ins.getPrizeInfoList[num].creditsPrice || 0;
        this.data.message = `是否愿意花费${costCredits}${unitName}复活 并消去5行方块`;
    }

    initEvents() {
        super.initEvents();
        this['okBtn'].once(egret.TouchEvent.TOUCH_TAP, this.onTouchTap_okBtn, this)
    }

    onTouchTap_closeBtn() {
        PanelCtrl.instance.closeCurrent(true);
        this.dispatchEvent(new egret.Event('onCancel'));
    }

    onTouchTap_okBtn() {
        this.closeBtns.forEach(
            btn => { if (btn) btn.touchEnabled = false }
        )
        relive(() => {
            this.hidePanel();
            this.dispatchEvent(new egret.Event('onSure'))
        })
    }

    get skinKey(): string { return 'Relive' }
}