import MainBase from "../libs/tl/MainBase";
import { NetManager } from "../libs/tw/manager/NetManager";
import Msg from "./alert/Msg";
import PanelCtrl from "./ctrls/panelCtrl";
import SceneCtrl from "./ctrls/sceneCtrl";
import OptionsPanel from "./optionsPanel/OptionsPanel";
import RulePanel from "./rulePanel/RulePanel";
import StartScene from "./startScene/StartScene";
import { ModuleTypes } from "./types/sceneTypes";

class Main extends MainBase {
    protected registerModules() {
        PanelCtrl.instance.registerPanelClass(ModuleTypes.MSG_PANEL, Msg);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.RULE_PANEL, RulePanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.OPTIONS_PANEL, OptionsPanel);
        SceneCtrl.instance.registerSceneClass(ModuleTypes.START_SCENE, StartScene);
    }

    protected getData() {
        super.getData();
        NetManager.ins.getInfo();
    }

    protected async createGameScene() {
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
    }
}

window['Main'] = Main;