import { DataManager } from "../manager/DataManager";

export class TwFun {
    /**
     * 获取兑换记录地址
     * @param actId 活动ID
     * @param type 入库活动(游戏、新活动工具、自定义活动工具、竞猜、答题)   —   00
     *             插件活动、插件式抽奖工具   —  01
     *             开心码   —   02
     *             集卡开奖 — 03
     */
    public static getRecordUrl(type: string ,ids?: number[]): string {
        let recordUrl: string;
        let oaId: number;
        if (DataManager.ins.customCfgData) {
            oaId = DataManager.ins.customCfgData.oaId;
            recordUrl = DataManager.ins.customCfgData.recordUrl;
        } else {
            oaId = DataManager.ins.gameCfgData.gameInfo.oaId;
            recordUrl = window['recordUrl'];
        }

        if(!ids) {
            ids = [oaId];
        }

        let i = 0;
        const len = ids.length;
        for(i; i < len; i++) {
            recordUrl += '?origins=' + ids[i] + type;
        }
        return recordUrl;
    }

    /**
     * 生成活动链接
     * @param type 1游戏、2活动工具
     * @param activityId 活动ID
     * @param dpm 点击埋点
     * @param dcm 曝光埋点
     */
    public static createActivityUrl(type: number, activityId: number, dpm: string, dcm: string): string {
        let url: string;
        switch (type) {
            case 1:
                url = '//activity.m.duiba.com.cn/ngame/duiba?id=';
                break;
            case 2:
                url = '//activity.m.duiba.com.cn/newActivity/duiba?id=';
                break;
        }
        return url + activityId + '&dbnewopen&dpm=' + dpm + '&dcm=' + dcm;
    }

    /**
     * 获取指定app指定索引的的活动ID
     * @param appId appId
     * @param pool 活动池
     * pool格式
     * {
     *      appId1: [activityId1, activityId2, activityId3, activityId4],
     *      appId2: [activityId1, activityId2, activityId3, activityId4]
     * }
     * 默认必须有内测的appId和对应的活动ID组
     * 当查找不到指定的appId则获取默认的内测数据
     * @param index 活动索引
     */
    public static getActivityIdByAppId(appId: number, pool: any, index: number): number {
        return pool[appId] ? pool[appId][index] : pool[1][index];
    }
}
