import getIsIOS from "../../new_tc/getIsIOS";
import doStart from "../../new_tw/ctrls/doStart";
import getCountTxt from "../../new_tw/datas/getCountTxt";
import getStartBtnEnable from "../../new_tw/datas/getStartBtnEnable";
import { DataManager } from "../../tw/manager/DataManager";
import PanelCtrl from "../ctrls/panelCtrl";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import Scene from "./Scene";

export default class StartSceneBase extends Scene {
    ruleBtn: eui.Button;
    htmlRuleBtn: eui.Button;
    optionBtn: eui.Button;
    recordBtn: eui.Button;
    startBtn: eui.Button;
    rankBtn: eui.Button;

    countTxt: eui.Label;
    exemptionTxt: eui.Label;
    bg: eui.Image;

    async start(data?) {
        this.startBtn.visible = false;
        this.updateGetInfoView();
        this.updateExemptionTxt();
        this.showElements();
    }

    showElements() {
        const btns = [this.bg, this.ruleBtn, this.optionBtn, this.recordBtn, this.rankBtn];
        btns.forEach(btn => {
            egret.Tween.get(btn).set({ alpha: 0 }).to({ alpha: 1 }, 700, egret.Ease.backOut);
        })
    }

    private updateGetInfoView() {
        if (DataManager.ins.getInfoData) {
            this.updateStartBtnStatus();
            this.updateCountTxt();
        } else {
            DataManager.ins.once('dataUpdate', this.updateGetInfoView, this);
        }
    }

    updateStartBtnStatus() {
        if (this.startBtn) {
            this.startBtn.visible = true;
            this.startBtn.enabled = getStartBtnEnable();
            egret.Tween.get(this.startBtn).set({ horizontalCenter: 750 }).to({ horizontalCenter: 0 }, 400, egret.Ease.elasticOut);
        }
    }

    updateCountTxt() {
        if (this.countTxt) {
            this.countTxt.text = getCountTxt();
            egret.Tween.get(this.countTxt).set({ horizontalCenter: 750 }).wait(400).to({ horizontalCenter: 0 }, 300, egret.Ease.backOut);
        }
    }

    updateExemptionTxt() {
        if (this.exemptionTxt) {
            if (getIsIOS()) {
                this.exemptionTxt.visible = true;
            } else {
                this.exemptionTxt.visible = false;
            }
        }
    }

    initEvents() {
        if (this.ruleBtn)
            this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        if (this.htmlRuleBtn)
            this.htmlRuleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_htmlRuleBtn, this);
        if (this.optionBtn)
            this.optionBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_optionBtn, this);
        if (this.recordBtn)
            this.recordBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_recordBtn, this);
        if (this.startBtn)
            this.startBtn.once(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this);
        if (this.rankBtn)
            this.rankBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_rankBtn, this);
    }

    onTap_ruleBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
    }
    onTap_htmlRuleBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.HTML_RULE_PANEL);
    }

    onTap_optionBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.OPTIONS_PANEL);
    }

    onTap_recordBtn(e: egret.Event) {
    }

    onTap_startBtn(e: egret.Event) {
        doStart();
        SceneCtrl.instance.change(ModuleTypes.PALY_SCENE);
    }
    onTap_rankBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.RANK_PANEL);
    }

    get skinKey() { return 'Start' }
}