import { addImage } from "./utils";
import { FACTOR } from "./consts";

/**
 * 被打的砖块
 */
export default class Brick extends p2.Body {
    _skin: egret.DisplayObject;
    constructor() {
        super();
        this.type = p2.Body.KINEMATIC;
        this.init();
    }

    init() {
        this._skin = addImage('rect1_png');
        this._skin.anchorOffsetX = this._skin.width / 2;
        this._skin.anchorOffsetY = this._skin.height / 2;

        const width = this._skin.width / FACTOR;
        const height = this._skin.height / FACTOR;
        const shape = new p2.Box({ width: width, height: height });
        this.addShape(shape);

        shape.collisionMask = 6;//010与001为0，010与110为1
    }

    updateSkin() {
        this._skin.x = this.position[0] * FACTOR;
        this._skin.y = this.position[1] * FACTOR;
        this._skin.rotation = this.angle * 180 / Math.PI;
    }

    get skin() { return this._skin }
}