import { addImage } from "./utils";
import { FACTOR } from "./consts";

export default class Ball extends p2.Body {
    _skin: egret.DisplayObject;
    setImpulse: boolean;
    constructor() {
        super({ mass: 10 });
        this.type = p2.Body.DYNAMIC;
        this.init();
    }

    private init() {
        this._skin = addImage('ball_png');
        this._skin.anchorOffsetX = this._skin.width / 2;
        this._skin.anchorOffsetY = this._skin.height / 2;

        const radius = this._skin.width / 2 / FACTOR;
        const shape = new p2.Circle({ radius: radius });
        this.addShape(shape);

        shape.collisionGroup = 2;//010与001为0，010与110为1
    }

    updateSkin() {
        this._skin.x = this.position[0] * FACTOR;
        this._skin.y = this.position[1] * FACTOR;
        this._skin.rotation = this.angle * 180 / Math.PI;
    }

    get skin() { return this._skin }
}