import { NetManager } from './../libs/tw/manager/NetManager';
import { ModuleTypes } from './../libs/new_wx/types/sceneTypes';
import StartScene from "./startScene/StartScene";
import PlayScene from "./playScene/PlayScene";
import MainBase from "../libs/new_wx/MainBase";
import PanelCtrl from '../libs/new_wx/ctrls/panelCtrl';
import SceneCtrl from '../libs/new_wx/ctrls/sceneCtrl';
import showAlertPanel from '../libs/new_wx/ctrls/showAlertPanel';
import ExNoPrizePanel from './NoPrizePanel/ExNoPrizePanel';
import RankPanel from '../libs/new_wx/components/RankPanel';
import PrizePanel from '../libs/new_wx/components/PrizePanel';
import OptionsPanel from '../libs/new_wx/components/OptionsPanel';
import HTMLRulePanel from '../libs/new_wx/components/HTMLRulePanel';
import RulePanel from '../libs/new_wx/components/RulePanel';
import Alert from '../libs/new_wx/components/Alert';

class Main extends MainBase {
    protected get startSceneConfig() {
        return { cls: StartScene }
    }
    protected get playSceneConfig() {
        return { cls: PlayScene }
    }

    protected registerModules() {
        const panels = [
            [ModuleTypes.ALERT_PANEL, { cls: Alert }],
            [ModuleTypes.RULE_PANEL, { cls: RulePanel }],
            [ModuleTypes.HTML_RULE_PANEL, { cls: HTMLRulePanel }],
            [ModuleTypes.OPTIONS_PANEL, { cls: OptionsPanel }],
            [ModuleTypes.PRIZE_PANEL, { cls: PrizePanel }],
            [ModuleTypes.RANK_PANEL, { cls: RankPanel }],
            [ModuleTypes.NOPRIZE_PANEL, { cls: ExNoPrizePanel }],
        ];

        const scenes = [
            [ModuleTypes.START_SCENE, this.startSceneConfig],
            [ModuleTypes.PLAY_SCENE, this.playSceneConfig]
        ];
        
        panels.forEach(item => PanelCtrl.instance.registerPanel(item[0], item[1]));
        scenes.forEach(item => SceneCtrl.instance.registerScene(item[0], item[1]));
        
        NetManager.ins.onNotSuccess = (msg) => {
            showAlertPanel(msg)
        }
    }
}


window['Main'] = Main;
egret.runEgret({
    renderMode: "webgl", audioType: 0, calculateCanvasScaleFactor: (context: any) => {
        const backingStore = context.backingStorePixelRatio ||
            context.webkitBackingStorePixelRatio ||
            context.mozBackingStorePixelRatio ||
            context.msBackingStorePixelRatio ||
            context.oBackingStorePixelRatio ||
            context.backingStorePixelRatio || 1;
        return (window.devicePixelRatio || 1) / backingStore;
    }
});