import { DataManager } from './../../libs/tw/manager/DataManager';

import Game from "./Game/Game";
import PlaySceneBase from "../../libs/new_wx/components/PlaySceneBase";
import PanelCtrl from "../../libs/new_wx/ctrls/panelCtrl";
import { ModuleTypes } from "../../libs/new_wx/types/sceneTypes";
import { NetManager } from "../../libs/tw/manager/NetManager";

const BABYLON = window['BABYLON'];
const { TouchEvent } = egret;
export default class PlayScene extends PlaySceneBase{
    public get skinKey() { return 'Play' }

    public touchPlaneL:eui.Rect;
    public touchPlaneR:eui.Rect;
    public scoreTxt:eui.Label;
    public scoreTip:eui.Image;

    public rocketP:any;
    public rocketLine:any;
    public score:number = 0; // 分数
    private touchDown:boolean; // 是否点击屏幕
    private createCount:number = 0; // 生成云的计数

    gameNode

    constructor(){
        super()
    
    }

    start(){
        let config = {
            meshMatUrl:"./resource/model/渐变蓝色.jpg",
            spFall:3000,
            beyondFriends : [{
                score:5,
                id:1
            },
            {
                score:15,
                id:2
            },
            {
                score:25,
                id:3
            },
            {
                score:35,
                id:4
            }],
            addScoreConfig:{
                score:1,
                continuouslyScore:10
            },
            gameLevels:{
                level1:{
                    endScore:20
                },
                level2:{
                    endScore:50
                },
                level3:{
                    endScore:80
                },
                level4:{
                    endScore:120
                },
                level5:{
                    endScore:200
                },
                level6:{
                    endScore:300
                },
                level7:{
                    endScore:400
                }
            }
        }
        if(this.gameNode){
            this.gameNode.restart(config,this)
        }else{
            this.gameNode = new Game(config,this)
        }
    }
    

    initEvents() {
        this.touchPlaneL.addEventListener( egret.TouchEvent.TOUCH_BEGIN, this.onTouchBegin_touchPlaneL, this);
        this.touchPlaneL.addEventListener( egret.TouchEvent.TOUCH_END, this.onTouchOut_touchPlaneL, this);
        this.touchPlaneL.addEventListener( egret.TouchEvent.TOUCH_CANCEL, this.onTouchOut_touchPlaneL, this);
        this.touchPlaneL.addEventListener( egret.TouchEvent.TOUCH_RELEASE_OUTSIDE, this.onTouchOut_touchPlaneL, this);
        
        this.touchPlaneR.addEventListener( egret.TouchEvent.TOUCH_BEGIN, this.onTouchBegin_touchPlaneR, this);
        this.touchPlaneR.addEventListener( egret.TouchEvent.TOUCH_END, this.onTouchOut_touchPlaneR, this);
        this.touchPlaneR.addEventListener( egret.TouchEvent.TOUCH_CANCEL, this.onTouchOut_touchPlaneR, this);
        this.touchPlaneR.addEventListener( egret.TouchEvent.TOUCH_RELEASE_OUTSIDE, this.onTouchOut_touchPlaneR, this);
        this.addEventListener(egret.Event.ENTER_FRAME,this.onEnterFrame,this);
    }

    removeEvents() {
        this.touchPlaneL.removeEventListener( egret.TouchEvent.TOUCH_BEGIN, this.onTouchBegin_touchPlaneL, this);
        this.touchPlaneL.removeEventListener( egret.TouchEvent.TOUCH_END, this.onTouchOut_touchPlaneL, this);
        this.touchPlaneL.removeEventListener( egret.TouchEvent.TOUCH_CANCEL, this.onTouchOut_touchPlaneL, this);
        this.touchPlaneL.removeEventListener( egret.TouchEvent.TOUCH_RELEASE_OUTSIDE, this.onTouchOut_touchPlaneL, this);
        
        this.touchPlaneR.removeEventListener( egret.TouchEvent.TOUCH_BEGIN, this.onTouchBegin_touchPlaneR, this);
        this.touchPlaneR.removeEventListener( egret.TouchEvent.TOUCH_END, this.onTouchOut_touchPlaneR, this);
        this.touchPlaneR.removeEventListener( egret.TouchEvent.TOUCH_CANCEL, this.onTouchOut_touchPlaneR, this);
        this.touchPlaneR.removeEventListener( egret.TouchEvent.TOUCH_RELEASE_OUTSIDE, this.onTouchOut_touchPlaneR, this);
        this.removeEventListener(egret.Event.ENTER_FRAME,this.onEnterFrame,this);
    }

    onEnterFrame(){
        this.gameNode?.scene?.render()
    }
    private onTouchBegin_touchPlaneL(e:egret.TouchEvent){
        this.gameNode&&(this.gameNode.touchDown = true);
        this.gameNode&&this.gameNode.touchLeft()
    }

    private onTouchOut_touchPlaneL(e:egret.TouchEvent){
        this.gameNode&&(this.gameNode.touchDown = false);
    }

    private onTouchBegin_touchPlaneR(e:egret.TouchEvent){
        this.gameNode&&(this.gameNode.touchDown = true);
        this.gameNode&& this.gameNode.touchRight()
    }

    private onTouchOut_touchPlaneR(e:egret.TouchEvent){
        this.gameNode&&(this.gameNode.touchDown = false);
    }



    


    // 游戏里会调用的方法
    gameOver(){
        this.gameSubmitData(this.gameSubmitResult.bind(this), this.score);
    }

    beyondFriend(id){
        let txt = new egret.TextField()
        txt.text = "超越好友 "+id
        txt.scaleX = 0
        txt.scaleY = 0
        txt.x = 300
        txt.y = this.stage.stageHeight/2;
        this.addChild(txt)
        egret.Tween.get(txt)
        .to({scaleX:1,scaleY:1},200)
        .wait(1000)
        .call(()=>{
            this.removeChild(txt)
        })
    }

    // 更新分数
    addScore(score?:number,layerNum?:number){
        let _score = 1;
        if(score){
            _score = score;
        }
        let scoreTip = new egret.TextField()
        scoreTip.text = "+"+score
        this.addChild(scoreTip)
        scoreTip.x = 350
        scoreTip.y = this.stage.stageHeight/2;
        scoreTip.textColor = 0xff0000;
        scoreTip.size = 60
        scoreTip.scaleX = 0;
        scoreTip.scaleY = 0;
        scoreTip.alpha = 1;

        let scoreTw = egret.Tween.get(scoreTip);
        scoreTw.to({scaleX:1,scaleY:1},200).to({y:this.stage.stageHeight/2 - 100,alpha:0},100);
        this.score += _score;
        this.scoreTxt.text = `${this.score}`;
    }

    // 处理提示 最快1秒一次
    handleTips(){

    }

    // 提交成绩的回调
    private gameSubmitResult(success){
        
        if(!success){
            return;
        }
        let data = {score:this.score}
        if(DataManager.ins.gameGetSubmitResultData && DataManager.ins.gameGetSubmitResultData.lottery){
            PanelCtrl.instance.show(ModuleTypes.PRIZE_PANEL,data);
        }else{
            PanelCtrl.instance.show(ModuleTypes.NOPRIZE_PANEL,data);
            // SceneCtrl.instance.change(ModuleTypes.NOPRIZE_PANEL, data);
        }
    }

    /**
     * 提交游戏成绩
     * @param callback 
     * @param score 得分
     * @param allDynamics 防作弊数据
     * @param checkScore  是否校验得分
     * @param customizedType 定制类型 1推币机    
     */
    protected gameSubmitData(callback: Function, score: number, checkScore?: boolean, customizedType?: number): void {
        NetManager.ins.gameSubmit(
            (success: boolean) => { 
                if(success) {
                    this.getSubmitResult(callback, DataManager.ins.gameSubmitData.orderId); 
                } else {
                    callback(success);
                }
            },
            DataManager.ins.doStartData.ticketId,
            score,
            '[]',
            DataManager.ins.doStartData.submitToken,
            '',
            checkScore,
            customizedType);
    }
    
    /**
     * 查询提交结果
     * @param callback 
     * @param orderId 
     */
    private getSubmitResult(callback: Function, orderId: number): void {
        NetManager.ins.getSubmitResult(callback, orderId, () => {
            return DataManager.ins.gameGetSubmitResultData.flag;
        });
    }


    

}