import Panel from "../views/Panel";
import { NetManager } from '../../libs/tw/manager/NetManager';
import { DataManager } from "../../libs/tw/manager/DataManager";
export default class RulePanel extends Panel {
    public labContent: eui.Label;
    public scroller: eui.Scroller;
    start() {
        if (!DataManager.ins.getRuleData)
            NetManager.ins.getRule(() => {
                this.addRule();
            });
        else
            this.addRule();
    }

    group:eui.Group;
    private addRule() {
        let text: string = DataManager.ins.getRuleData.ruleText;

        text = text.replace('/<div>/g', '');
        text = text.replace('/</div>/g', '');
        text = text.replace('/<br>/g', '<br> ');
        const textlist = text.split('<br>');


        console.log(text);
        // this.labContent.textFlow = (new egret.HtmlTextParser).parser(DataManager.ins.getRuleData.ruleText);

        for (let i = 0; i < textlist.length; i++) {
            const l = new eui.Label();
            l.textColor=this.labContent.textColor;
            l.size=this.labContent.size;
            l.width=this.labContent.width;
            l.minHeight=20;
            l.textFlow = (new egret.HtmlTextParser).parser(textlist[i]+'');
            this.group.addChild(l)
        }
    }

    protected get skinKey() { return 'Rule' }
}